/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																			       *
 *	    Orbit tree (binary red-black tree implementation) Abstract Data Type.      *
 *																				   *
 *								  Header file									   *
 *																				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef enum { orbit_tree_BLACK, orbit_tree_RED } orbit_tree_nodeColor; /* tree node color */

typedef struct orbit_tree_node_structure {
    struct orbit_tree_node_structure *left;       /* left child */
    struct orbit_tree_node_structure *right;      /* right child */
    struct orbit_tree_node_structure *parent;     /* parent */
    orbit_tree_nodeColor color;					  /* node color (BLACK, RED) */
	orbit_ptr orbit;							  /* Pointer to orbit structure */


} orbit_tree_node, *orbit_tree_node_ptr;

typedef struct orbit_tree_structure {
	orbit_tree_node *root;
	unsigned long int size;
} orbit_tree, *orbit_tree_ptr;

#define orbit_tree_compLT(a,b) memcmp(a,b,sizeof(coordinate_item)*(owe_setting.metric_polytope.dimension+1))<0	/* "Less than" coordinate comparator. For basic types this would be: compLT(a,b) (a < b) */

#define orbit_tree_compEQ(a,b) memcmp(a,b,sizeof(coordinate_item)*(owe_setting.metric_polytope.dimension+1))==0	/* "Equal" coordinate comparator; for basic types this would be: compEQ(a,b) (a == b) */

#define orbit_tree_NIL &orbit_tree_sentinel	/* all leafs are sentinels */


/* Function prototypes */
	/* Access functions */
		/* Constructor */
		void orbit_tree_initialize(orbit_tree_ptr tree);

		/* Destructor */
		void orbit_tree_delete(orbit_tree_ptr tree);

		/* Insert orbit */
		orbit_ptr orbit_tree_insert(orbit_tree_ptr tree, coordinate canonical_representative);

		/* Find an orbit */
		orbit_ptr orbit_tree_find(orbit_tree_ptr tree, coordinate canonical_representative);

		/* Print the full detailed contents of the orbit tree. */
		void orbit_tree_print_orbits_lexicographically_ordered(orbit_tree_ptr tree, FILE* auxiliary_output);

		/* Load the contents of a orbit tree into an orbit queue. */
		void orbit_tree_load_orbits_into_queue(orbit_tree_ptr tree, incidence_sorted_orbit_priority_queue_ptr queue);



	/* Internal functions */
		/* tree rotation (left) function */
		static void orbit_tree_rotateLeft(orbit_tree_node_ptr *tree, orbit_tree_node *x);
		
		/* tree rotation (right) function */
		static void orbit_tree_rotateRight(orbit_tree_node_ptr *tree, orbit_tree_node *x);
		
		/* Fixup function */
		static void orbit_tree_insertFixup(orbit_tree_node_ptr *tree, orbit_tree_node *x);

		/* Orbit tree structure deletion function. */
		void orbit_tree_delete_tree_structure(orbit_tree_ptr tree);

		/* In order tree parsing (used by debug function orbit_tree_print_orbits). */
		void orbit_tree_print_orbits_inorder(orbit_tree_node *node);

		/* In order tree parsing (used by debug function orbit_tree_print_canonical_representatives). */
		void orbit_tree_print_canonical_representatives_inorder(orbit_tree_node *node);

	/* Functions for debug purposes. */
		/* print orbit tree (orbit canonical representatives only) */
		void orbit_tree_print_canonical_representatives(orbit_tree *tree);
