/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																			       *
 *							   MPI-OWE main source file							   *
 *																				   *
 *	 Parallel Orbitwise vertex enumeration algorithm for combinatorial polyhedra   *	
 *																				   *
 *						Antoine Deza			Gabriel Indik					   *
 *																				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include"owe_header.h"

/* owe_setting variable structure. */
struct owe_setting_variables owe_setting;

int main(int argc, char *argv[]) {

	int process_rank;	/* Variable used to determine the rank of the process. */
	int processes;		/* Variable used to determine the total number of processes. */
	char process_output_file_name[32];		/* Name of the file in which the process will place its output. */

	/* Initialize MPI. */
	MPI_Init(&argc,&argv);

	/* Obtain the rank of the process. */
	MPI_Comm_rank(MPI_COMM_WORLD,&process_rank);

	/* Obtain the total number of processes. */
	MPI_Comm_size(MPI_COMM_WORLD,&processes);


	/* Execute either the master or slave process depending on the rank (master
	is process 0, slave are all others. */
	if(!process_rank) {
			/* Redirect standard output to a file for the master process. */
			freopen("output.txt", "w", stdout);
			
			/* Execute master process. */
			owe_master_process_execute();
	}
	else {
			/* Redirect standard output to a file with the name of the process rank. */
			sprintf(process_output_file_name,"expanded_output_%u_of_%u",process_rank, processes-1); strcat(process_output_file_name,".txt");
			freopen(process_output_file_name, "w", stdout);

			/* Execute slave process */
			owe_slave_process_execute();
	}
		
	/* Finalize MPI. */
	MPI_Finalize();

	return(0);
}

