/* computing canonical representative w.r.t. the permutations */
#include "canon_libcanon.h"
#include "canon_libtree.h"
#include<string.h>

static int *perms; 
static int nperm = 0;

static Matentry *images;
static struct Tree* tree;
static int maxlen;
static int npairs;

void init_perm_canon(const int n) {
  if (nperm) exit(8); /* calling 2nd time ! */
  perms = sym_n_pairs(n);
  nperm = 2;
  maxlen = nfac(n);
  npairs = n*(n-1)/2;
  images = (Matentry*)calloc((maxlen+1)*npairs, sizeof(Matentry));
  tree = (struct Tree*)calloc(maxlen, sizeof(struct Tree));
}

void perm_canon(Matentry a[]) {
  struct Tree *f;
  Matentry *q0, *q1;
  f = tree;
  q0 = images;
  q1 = q0;
  memmove((void *)q0, (const void*)a, npairs*sizeof(Matentry));
  tree_insert(q1, f++);
  q1 += npairs;
  
  /* computing the orbit */
  while(q0 < q1) {
    int igen, *p;
    p = perms;
    for (igen = 0; igen < nperm; igen++, p += npairs) {
      int res;
      perm_act(p, q0, q1, npairs);
      res = tree_find_insert(q1, f, npairs, tree); 
      if (res) {
	q1 += npairs;
	f++;
      }
    }
    q0 += npairs;
  }

  /* finding minimal element */
  f = tree;
  while(f->left) f = f->left;
  memmove((void *)a, (const void*)(f->data), npairs*sizeof(Matentry));
}
  
