function s = accdot(t,u)
% Accurate dot product calculation reducing numerical error.
% Input      : u and v are vectors of the same dimension.
% Output     : s is the dot product of u and v.
% Description:
%   let x=[x1 x2 x3 ...] and y=[y1 y2 y3 ...], such that |x1*y1| is much
%   larger than other |xi*yi| but not too much larger than
%   |x2*y2+x3*y3+...|. A simple implementation of dot product may return
%   only dot(x,y)=x1*y1. This routine can reduce the error caused by these
%   kind of cases.
%     The draw back is that it increase the complexity from O(n) to
%   O(nlgn).
v = t.*u;
posv = sort(v(v>=0),'ascend');
negv = sort(v(v<0) ,'descend');
s = sum(posv)+sum(negv);
return