/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.geo.proj;

import drasys.or.geom.GeomException;
import drasys.or.geom.geo.CoordinateSystem;
import drasys.or.geom.geo.RangeI;
import drasys.or.geom.geo.proj.Projection;
import drasys.or.geom.geo.proj.ProjectionI;

public abstract class Conic
extends Projection
implements ProjectionI {
    protected double _north;
    protected double _south;

    public Conic(double d, double d2) throws GeomException {
        this.init(d, d2);
    }

    public Conic(RangeI rangeI) throws GeomException {
        double d = (rangeI.north() - rangeI.south()) / 3.0;
        this.init(rangeI.north() - d, rangeI.south() + d);
    }

    public double getNorthParallel() {
        return this._north / 0.01745329251994;
    }

    public double getSouthParallel() {
        return this._south / 0.01745329251994;
    }

    private void init(double d, double d2) throws GeomException {
        if (Math.abs(d + d2) < CoordinateSystem.getInstance().getAccuracy()) {
            throw new GeomException("Latitude1 equals -Latitude2");
        }
        this._north = 0.01745329251994 * Math.min(90.0, Math.max(d, d2));
        this._south = 0.01745329251994 * Math.max(-90.0, Math.min(d, d2));
        this.setEllipsoid(this._ellipsoid);
    }
}

