/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.ArrayMatrix;
import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import drasys.or.util.Array;
import java.util.Enumeration;

public class ColumnArrayMatrix
extends ArrayMatrix {
    int _capacityOfRows = 0;

    public ColumnArrayMatrix(int n, int n2) {
        super(n, n2);
        this._capacityOfRows = n;
        this._values = new double[n2][];
    }

    public ColumnArrayMatrix(int n, int n2, int n3, int n4) {
        super(n, n2);
        this._capacityOfRows = this._sizeOfRows;
        this._values = new double[n4][];
    }

    public ColumnArrayMatrix(MatrixI matrixI) {
        super(matrixI.sizeOfRows(), matrixI.sizeOfColumns());
        this._capacityOfRows = this._sizeOfRows;
        this._values = new double[this._sizeOfColumns][];
        int n = 0;
        while (n < this._sizeOfColumns) {
            this._values[n] = new double[this._capacityOfRows];
            ++n;
        }
        Enumeration enumeration = matrixI.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            int n2 = matrixElementI.getColumnIndex();
            double[] dArray = this._values[n2];
            if (dArray == null) {
                this._values[n2] = new double[this._capacityOfRows];
                dArray = this._values[n2];
            }
            dArray[matrixElementI.getRowIndex()] = matrixElementI.getValue();
        }
    }

    public ColumnArrayMatrix(VectorI vectorI) {
        super(vectorI.size(), vectorI.size());
        this._capacityOfRows = this._sizeOfRows;
        this._values = new double[this._sizeOfColumns][];
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            double[] dArray = this._values[vectorElementI.getIndex()];
            if (dArray == null) {
                double[] dArray2 = new double[this._capacityOfRows];
                this._values[vectorElementI.getIndex()] = dArray2;
                dArray = dArray2;
            }
            dArray[vectorElementI.getIndex()] = vectorElementI.getValue();
        }
    }

    public ColumnArrayMatrix(double[][] dArray) {
        super(dArray);
        this._capacityOfRows = this._sizeOfRows;
        this._values = new double[this._sizeOfColumns][this._capacityOfRows];
        int n = 0;
        while (n < this._sizeOfColumns) {
            double[] dArray2 = this._values[n];
            int n2 = 0;
            while (n2 < this._sizeOfRows) {
                double[] dArray3 = dArray[n2];
                if (dArray3 != null && n < dArray3.length) {
                    dArray2[n2] = dArray3[n];
                }
                ++n2;
            }
            ++n;
        }
    }

    public void addColumn(VectorI vectorI) {
        if (this._sizeOfColumns >= this.capacityOfColumns()) {
            this.setCapacity(this._sizeOfRows, 2 * this._sizeOfColumns);
        }
        int n = this._sizeOfColumns;
        this.setSize(this._sizeOfRows, this._sizeOfColumns + 1);
        if (vectorI == null) {
            return;
        }
        double[] dArray = null;
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n2 = vectorElementI.getIndex();
            if (dArray == null) {
                this._values[n] = new double[this._capacityOfRows];
                dArray = this._values[n];
            }
            dArray[n2] = vectorElementI.getValue();
        }
    }

    public void addRow(VectorI vectorI) {
        if (this._sizeOfRows >= this.capacityOfRows()) {
            this.setCapacity(2 * this._sizeOfRows, this._sizeOfColumns);
        }
        int n = this._sizeOfRows;
        this.setSize(this._sizeOfRows + 1, this._sizeOfColumns);
        if (vectorI == null) {
            return;
        }
        double[] dArray = null;
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n2 = vectorElementI.getIndex();
            dArray = this._values[n];
            if (dArray == null) {
                this._values[n] = new double[this._capacityOfRows];
                dArray = this._values[n];
            }
            dArray[n] = vectorElementI.getValue();
        }
    }

    public int capacityOfColumns() {
        return this._values.length;
    }

    public int capacityOfRows() {
        return this._capacityOfRows;
    }

    public Enumeration columnElements(int n) {
        if (n < 0 || n >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return new ColumnEnum(n);
    }

    public double elementAt(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        double[] dArray = this._values[n2];
        return dArray == null ? 0.0 : dArray[n];
    }

    public Enumeration elements() {
        return new Enum();
    }

    public double[][] getArray() {
        double[][] dArray = new double[this._sizeOfRows][this._sizeOfColumns];
        int n = 0;
        while (n < this._sizeOfColumns) {
            double[] dArray2 = this._values[n];
            if (dArray2 != null) {
                int n2 = 0;
                while (n2 < this._sizeOfRows) {
                    dArray[n2][n] = dArray2[n2];
                    ++n2;
                }
            }
            ++n;
        }
        return dArray;
    }

    public boolean isColumnMajor() {
        return true;
    }

    public boolean isNull(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return this._values[n2] == null;
    }

    public boolean isRowMajor() {
        return false;
    }

    public Enumeration rowElements(int n) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        return new RowEnum(n);
    }

    public void setCapacity(int n, int n2) {
        if (n2 > this.capacityOfColumns()) {
            this._values = Array.resize(n2, this._values);
        }
        if (n > this._capacityOfRows) {
            int n3 = 0;
            while (n3 < this._sizeOfColumns) {
                double[] dArray = this._values[n3];
                if (dArray != null) {
                    this._values[n3] = Array.resize(n, dArray);
                }
                ++n3;
            }
        }
        this._capacityOfRows = n;
    }

    public void setElementAt(int n, int n2, double d) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        double[] dArray = this._values[n2];
        if (dArray == null) {
            this._values[n2] = new double[this._capacityOfRows];
            dArray = this._values[n2];
        }
        dArray[n] = d;
    }

    public void setSize(int n, int n2) {
        int n3;
        if (n >= this.capacityOfRows() || n2 >= this.capacityOfColumns()) {
            this.setCapacity(n, n2);
        }
        if (n2 < this._sizeOfColumns) {
            n3 = n2;
            while (n3 < this._sizeOfColumns) {
                this._values[n3] = null;
                ++n3;
            }
        }
        this._sizeOfColumns = n2;
        if (n > this._sizeOfRows) {
            n3 = n - this._sizeOfRows;
            if (n3 == 1) {
                int n4 = 0;
                while (n4 < this._sizeOfColumns) {
                    double[] dArray = this._values[n4];
                    if (dArray != null) {
                        dArray[this._sizeOfRows] = 0.0;
                    }
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < this._sizeOfColumns) {
                    double[] dArray = this._values[n5];
                    if (dArray != null) {
                        Array.copy(n3, dArray, this._sizeOfRows, 1, 0.0);
                    }
                    ++n5;
                }
            }
        }
        this._sizeOfRows = n;
    }

    public int sizeOfElements() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._sizeOfColumns) {
            if (this._values[n2] != null) {
                n += this._sizeOfRows;
            }
            ++n2;
        }
        return n;
    }

    public double sum(int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        if (n5 < 1) {
            return 0.0;
        }
        double d = 0.0;
        while (n3 < n4) {
            double[] dArray = this._values[n3];
            if (dArray == null) continue;
            d += Array.sum(n5, dArray, n, 1);
            ++n3;
        }
        return d;
    }

    public double sumOfSquaredDifferences(int n, int n2, int n3, int n4, double d) {
        int n5 = n2 - n;
        if (n5 < 1) {
            return 0.0;
        }
        double d2 = 0.0;
        int n6 = 0;
        while (n3 < n4) {
            double[] dArray = this._values[n3];
            if (dArray == null) {
                n6 += n5;
                continue;
            }
            d2 += Array.sumOfSquaredDifferences(n5, dArray, n, 1, d);
            ++n3;
        }
        if (d != 0.0) {
            d2 += (double)n6 * d * d;
        }
        return d2;
    }

    public double sumOfSquares(int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        if (n5 < 1) {
            return 0.0;
        }
        double d = 0.0;
        while (n3 < n4) {
            double[] dArray = this._values[n3];
            if (dArray == null) continue;
            d += Array.sumOfSquares(n5, dArray, n, 1);
            ++n3;
        }
        return d;
    }

    private class Enum
    implements Enumeration,
    MatrixElementI {
        int _i = 0;
        int _j = 0;
        double[] _column = null;
        int _mi;
        int _mj;
        double _mvalue;
        double[] _mcolumn;

        Enum() {
            while (this._j < ColumnArrayMatrix.this._sizeOfColumns && (this._column = ColumnArrayMatrix.this._values[this._i]) == null) {
                ++this._j;
            }
        }

        public int getColumnIndex() {
            return this._mj;
        }

        public int getRowIndex() {
            return this._mi;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._column != null;
        }

        public Object nextElement() {
            if (this._column == null) {
                return null;
            }
            this._mi = this._i;
            this._mj = this._j++;
            this._mcolumn = this._column;
            this._mvalue = this._column[this._i++];
            if (this._i >= ColumnArrayMatrix.this._sizeOfRows) {
                this._column = null;
                this._i = 0;
                while (this._j < ColumnArrayMatrix.this._sizeOfColumns && (this._column = ColumnArrayMatrix.this._values[this._j]) == null) {
                    ++this._j;
                }
            }
            return this;
        }

        public void setValue(double d) {
            this._mcolumn[this._mi] = this._mvalue = d;
        }
    }

    private class ColumnEnum
    implements Enumeration,
    MatrixElementI {
        int _i = 0;
        double[] _column = null;
        int _mi;
        int _mj;
        double _mvalue;
        double[] _mcolumn;

        ColumnEnum(int n) {
            this._mj = n;
            this._column = ColumnArrayMatrix.this._values[n];
            this._mcolumn = this._column;
        }

        public int getColumnIndex() {
            return this._mj;
        }

        public int getRowIndex() {
            return this._mi;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._column != null;
        }

        public Object nextElement() {
            if (this._column == null) {
                return null;
            }
            this._mi = this._i;
            this._mvalue = this._column[this._i++];
            if (this._i >= ColumnArrayMatrix.this._sizeOfRows) {
                this._column = null;
            }
            return this;
        }

        public void setValue(double d) {
            this._mcolumn[this._mi] = this._mvalue = d;
        }
    }

    private class RowEnum
    implements Enumeration,
    MatrixElementI {
        int _j = 0;
        double[] _column = null;
        int _mi;
        int _mj;
        double _mvalue;
        double[] _mcolumn;

        RowEnum(int n) {
            this._mi = n;
            while (this._j < ColumnArrayMatrix.this._sizeOfColumns && (this._column = ColumnArrayMatrix.this._values[this._j]) == null) {
                ++this._j;
            }
        }

        public int getColumnIndex() {
            return this._mj;
        }

        public int getRowIndex() {
            return this._mi;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._column != null;
        }

        public Object nextElement() {
            if (this._column == null) {
                return null;
            }
            this._mj = this._j++;
            this._mcolumn = this._column;
            this._mvalue = this._column[this._mi];
            this._column = null;
            while (this._j < ColumnArrayMatrix.this._sizeOfColumns && (this._column = ColumnArrayMatrix.this._values[this._j]) == null) {
                ++this._j;
            }
            return this;
        }

        public void setValue(double d) {
            this._mcolumn[this._mi] = this._mvalue = d;
        }
    }
}

