/*
 * Decompiled with CFR 0.152.
 */
package generating;

import generating.JobsGenerator;
import logging.Logger;
import mapping.Mapper;
import mapping.data.JobClass;

public class GeneratorsController {
    private Mapper mapper;
    private JobsGenerator[] generators;
    private Thread[] threads;

    public GeneratorsController(Mapper mapper) {
        this.setMapper(mapper);
    }

    public void startGenerators() {
        this.setGenerators(new JobsGenerator[this.getMapper().getClassesTable().size()]);
        this.setThreads(new Thread[this.getMapper().getClassesTable().size()]);
        this.logTheStartDate();
        int i = 0;
        while (i < this.getMapper().getClassesTable().size()) {
            this.getGenerators()[i] = new JobsGenerator((JobClass)this.getMapper().getClassesTable().get(i + 1), this.getMapper());
            this.getThreads()[i] = new Thread(this.getGenerators()[i]);
            this.getThreads()[i].start();
            ++i;
        }
    }

    public void logTheStartDate() {
        Logger logger = new Logger("generating");
        logger.log("");
        logger.closeStreams();
    }

    public void stopGenerators() {
        int i = 0;
        while (i < this.getGenerators().length) {
            this.getGenerators()[i].setAlive(false);
            this.getThreads()[i].interrupt();
            this.getThreads()[i] = null;
            ++i;
        }
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public JobsGenerator[] getGenerators() {
        return this.generators;
    }

    public void setGenerators(JobsGenerator[] generators) {
        this.generators = generators;
    }

    public Thread[] getThreads() {
        return this.threads;
    }

    public void setThreads(Thread[] threads) {
        this.threads = threads;
    }
}

