/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import generating.GeneratorsController;
import interfacing.AvailableServerQueueJPanel;
import interfacing.ExtensionFileFilter;
import interfacing.JobClassesStatisticsJPanel;
import interfacing.JobClassesTableJPanel;
import interfacing.JobsTableJPanel;
import interfacing.LP_JPanel;
import interfacing.MueJPanel;
import interfacing.ProgressBarFrame;
import interfacing.ServersAvailabilityJPanel;
import interfacing.ServersTableJPanel;
import interfacing.SystemLevelParametersJPanel;
import interfacing.SystemLevelStatisticsJPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import logging.Reporter;
import logging.SavingRunnable;
import logging.ServersReader;
import mapping.AvailabilityServer;
import mapping.CompletionServer;
import mapping.LPAS_DG_MS;
import mapping.Mapper;
import mapping.data.JobClassesTable;
import mapping.data.ServersTable;

public class MainFrame
extends JFrame
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 3585617362601575717L;
    private Mapper mapper;
    private AvailabilityServer availabilityServer;
    private CompletionServer completionServer;
    private SavingRunnable savingRunnable;
    protected JTabbedPane tabbedPane;
    private JScrollPane definitionScrollPane;
    protected JTabbedPane serversAndJobsClassesTablesTabbedPane;
    private SystemLevelParametersJPanel systemLevelParametersJPanel;
    private ServersTableJPanel serversTableJPanel;
    private JobClassesTableJPanel jobClassesTableJPanel;
    private ServersAvailabilityJPanel serversAvailabilityPanel;
    private JScrollPane monitoringScrollPane;
    private JTabbedPane monitoringTabbedPane;
    private JobsTableJPanel jobsTableJPanel;
    private AvailableServerQueueJPanel availableServersJPanel;
    private JScrollPane statisticsScrollPane;
    protected JTabbedPane statisticsTabbedPane;
    private JobClassesStatisticsJPanel jobClassesJPanel;
    private GeneratorsController generatorsController;
    private JButton startJButton;
    private JButton stopJButton;
    private JButton saveJButton;
    private JButton loadJButton;
    private JButton printMapperJButton;
    private JButton failureTraceButton;
    private JButton fillProcessingRate;
    private JButton startServers;
    private JButton pauseServers;
    private JButton killServers;
    private String Readfile;
    JToolBar toolBar = new JToolBar("Still draggable");
    private JMenuBar menuBar;
    private final int ITEM_PLAIN = 0;
    private final int ITEM_CHECK = 1;
    private final int ITEM_RADIO = 2;
    private JMenu menuAction;
    private JMenuItem menuItemStart = null;
    private JMenuItem menuItemStop = null;
    private JMenuItem menuItemFailureTraces = null;
    private JMenuItem menuItemProcessingRates = null;
    private JMenu menuTables;
    private JMenuItem menuItemSaveDefinitions = null;
    private JMenuItem menuItemLoadDefinitions = null;
    private JMenuItem menuItemSaveSystemStats = null;
    private JMenuItem menuItemSaveJobClassesStats = null;
    private JMenuItem menuItemSaveMueMatrix = null;
    private JMenuItem menuItemSaveJobTable = null;
    private JMenuItem menuItemSaveAll = null;
    private JMenu menuServers;
    private JMenuItem menuItemStartServers = null;
    private JMenuItem menuItemPingServers = null;
    private JMenuItem menuItemPauseServers = null;
    private JMenuItem menuItemKillServers = null;
    private JMenuItem menuItemPrint = null;
    private JMenu menuHelp;
    private JMenuItem menuItemManual = null;
    private JMenuItem menuItemThesis = null;
    private JMenu menuAbout;
    private JMenuItem menuItemAbout = null;
    public static final String iconsFolder = "Icons";

    public String getReadFile() {
        return this.Readfile;
    }

    public void setReadFile(String readfile) {
        this.Readfile = readfile;
    }

    public MainFrame() {
        this.setMapper(new Mapper());
        this.getMapper().setTimeUnitInMinutes(2.0);
        try {
            this.buildJobClasses();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.buildServers();
        this.getMapper().setMappingScheme(new LPAS_DG_MS(this.getMapper()));
        this.availabilityServer = new AvailabilityServer(this.getMapper());
        this.completionServer = new CompletionServer(this.getMapper());
        this.getMapper().fillAllFailureTraces();
        this.setGeneratorsController(new GeneratorsController(this.getMapper()));
        this.savingRunnable = new SavingRunnable(this.getMapper(), this.getGeneratorsController(), 20);
        this.tabbedPane = new JTabbedPane();
        this.serversAndJobsClassesTablesTabbedPane = new JTabbedPane();
        this.systemLevelParametersJPanel = new SystemLevelParametersJPanel(this);
        this.jobClassesTableJPanel = new JobClassesTableJPanel(this);
        this.serversTableJPanel = new ServersTableJPanel(this);
        this.serversAvailabilityPanel = new ServersAvailabilityJPanel(this);
        this.getMapper().getServersTable().addServersListener(this.serversTableJPanel);
        this.serversAndJobsClassesTablesTabbedPane.setTabPlacement(2);
        this.serversAndJobsClassesTablesTabbedPane.add("General", this.systemLevelParametersJPanel);
        this.serversAndJobsClassesTablesTabbedPane.add("Job Classes", this.jobClassesTableJPanel);
        this.serversAndJobsClassesTablesTabbedPane.add("Servers", this.serversTableJPanel);
        this.serversAndJobsClassesTablesTabbedPane.add("Availability", this.serversAvailabilityPanel);
        this.serversAndJobsClassesTablesTabbedPane.add("LP", new LP_JPanel(this));
        this.definitionScrollPane = new JScrollPane(this.serversAndJobsClassesTablesTabbedPane);
        this.monitoringTabbedPane = new JTabbedPane();
        this.jobsTableJPanel = new JobsTableJPanel(this);
        this.availableServersJPanel = new AvailableServerQueueJPanel(this);
        this.getMapper().getJobsTable().addJobsTableListener(this.jobsTableJPanel);
        this.monitoringTabbedPane.setTabPlacement(2);
        this.monitoringTabbedPane.add("Jobs Table", this.jobsTableJPanel);
        this.monitoringTabbedPane.add("Available Servers", this.availableServersJPanel);
        this.monitoringScrollPane = new JScrollPane(this.monitoringTabbedPane);
        this.statisticsTabbedPane = new JTabbedPane();
        this.statisticsTabbedPane.setTabPlacement(2);
        this.statisticsTabbedPane.add("General", new SystemLevelStatisticsJPanel(this));
        this.jobClassesJPanel = new JobClassesStatisticsJPanel(this);
        this.jobClassesJPanel.setEnabled(false);
        this.statisticsTabbedPane.add("Job Classes", this.jobClassesJPanel);
        this.statisticsTabbedPane.add("Processing Rates", new MueJPanel(this));
        this.statisticsScrollPane = new JScrollPane(this.statisticsTabbedPane);
        this.tabbedPane.add("Definitions", this.definitionScrollPane);
        this.tabbedPane.add("Monitoring", this.monitoringScrollPane);
        this.tabbedPane.add("Statistics", this.statisticsScrollPane);
        this.startJButton = new JButton("Start");
        this.stopJButton = new JButton("Stop");
        this.saveJButton = new JButton("Save Definitions");
        this.loadJButton = new JButton("Load Definitions");
        this.printMapperJButton = new JButton("Print");
        this.failureTraceButton = new JButton("Fill Traces");
        this.fillProcessingRate = new JButton("Calculate Processing Rates");
        this.startServers = new JButton("Start Servers");
        this.pauseServers = new JButton("Pause Servers");
        this.killServers = new JButton("Kill Servers");
        this.startJButton.setIcon(new ImageIcon("Icons/player_play_22.png"));
        this.stopJButton.setIcon(new ImageIcon("Icons/player_stop_22.png"));
        this.saveJButton.setIcon(new ImageIcon("Icons/filesave_22.png"));
        this.loadJButton.setIcon(new ImageIcon("Icons/filerevert_22.png"));
        this.failureTraceButton.setIcon(new ImageIcon("Icons/reload_22.png"));
        this.fillProcessingRate.setIcon(new ImageIcon("Icons/reload_22.png"));
        this.startServers.setIcon(new ImageIcon("Icons/player_play_22.png"));
        this.pauseServers.setIcon(new ImageIcon("Icons/player_pause_22.png"));
        this.killServers.setIcon(new ImageIcon("Icons/reload_22.png"));
        this.printMapperJButton.setIcon(new ImageIcon("Icons/fileprint_22.png"));
        this.startJButton.setToolTipText("Starts the operations of generations and mapping.");
        this.stopJButton.setToolTipText("Stops the operations of generations and mapping.");
        this.saveJButton.setToolTipText("Saves the definitions.");
        this.loadJButton.setToolTipText("Loades the definitions");
        this.failureTraceButton.setToolTipText("Generate a failure trace for all servers.");
        this.fillProcessingRate.setToolTipText("Refresh the processing Rates.");
        this.startServers.setToolTipText("Starts the Pullers on servers");
        this.pauseServers.setToolTipText("Stop the Pullers on servers");
        this.killServers.setToolTipText("Kill the Pullers on servers");
        this.printMapperJButton.setToolTipText("Starts the operations of generations and mapping.");
        this.toolBar.setPreferredSize(new Dimension(70, 25));
        this.toolBar.add(this.saveJButton);
        this.toolBar.add(this.loadJButton);
        this.toolBar.addSeparator(new Dimension(10, 10));
        this.toolBar.add(this.failureTraceButton);
        this.toolBar.add(this.fillProcessingRate);
        this.toolBar.addSeparator(new Dimension(10, 10));
        this.toolBar.add(this.startServers);
        this.toolBar.add(this.pauseServers);
        this.toolBar.addSeparator(new Dimension(10, 10));
        this.toolBar.add(this.startJButton);
        this.toolBar.add(this.stopJButton);
        this.toolBar.addSeparator(new Dimension(10, 10));
        this.startJButton.addActionListener(this);
        this.stopJButton.addActionListener(this);
        this.saveJButton.addActionListener(this);
        this.loadJButton.addActionListener(this);
        this.printMapperJButton.addActionListener(this);
        this.failureTraceButton.addActionListener(this);
        this.fillProcessingRate.addActionListener(this);
        this.startServers.addActionListener(this);
        this.pauseServers.addActionListener(this);
        this.killServers.addActionListener(this);
        this.getContentPane().add(this.tabbedPane);
        this.getContentPane().add((Component)this.toolBar, "First");
        this.stopJButton.setEnabled(false);
        this.buildMenuBar();
        this.addWindowListener(this);
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public GeneratorsController getGeneratorsController() {
        return this.generatorsController;
    }

    public void setGeneratorsController(GeneratorsController generatorsController) {
        this.generatorsController = generatorsController;
    }

    public static void main(String[] args) {
        MainFrame frame = new MainFrame();
        frame.setDefaultCloseOperation(0);
        frame.setSize(1024, 786);
        frame.setTitle("McMaster Grid Scheduling Testing Environment");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - frame.getWidth() / 2, screenSize.height / 2 - frame.getHeight() / 2);
        frame.setVisible(true);
    }

    public void buildMenuBar() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.menuAction = new JMenu("Action");
        this.menuAction.setMnemonic('A');
        this.menuItemStart = this.createMenuItem(this.menuAction, 0, "Start", null, 83, null);
        this.menuItemStop = this.createMenuItem(this.menuAction, 0, "Stop", null, 80, null);
        this.menuItemFailureTraces = this.createMenuItem(this.menuAction, 0, "Fill Failure Traces", null, 70, null);
        this.menuItemProcessingRates = this.createMenuItem(this.menuAction, 0, "Fill Processing Rates", null, 82, null);
        this.menuItemStop.setEnabled(false);
        this.menuBar.add(this.menuAction);
        this.menuTables = new JMenu("Tables");
        this.menuTables.setMnemonic('T');
        this.menuItemSaveDefinitions = this.createMenuItem(this.menuTables, 0, "Export Definitons", null, 83, null);
        this.menuItemSaveDefinitions.setToolTipText("Use this option to export the machine definitions, execution rates and job class definitions.");
        this.menuItemLoadDefinitions = this.createMenuItem(this.menuTables, 0, "Import Definitions", null, 76, null);
        this.menuItemLoadDefinitions.setToolTipText("Use this option to import the machine definitions, execution rates and job class definitions.");
        this.menuTables.addSeparator();
        this.menuItemSaveSystemStats = this.createMenuItem(this.menuTables, 0, "Export Generic Statistics", null, 89, null);
        this.menuItemSaveSystemStats.setToolTipText("Use this option to export generic statistics such as Start Time, End Time, Scheduling Scheme and the average Waiting Time.");
        this.menuItemSaveJobClassesStats = this.createMenuItem(this.menuTables, 0, "Export Job Classes Statistics", null, 67, null);
        this.menuItemSaveJobClassesStats.setToolTipText("Use this option to export statistics about job classes such as Number of Jobs, Arrival Rate and Actual Arrival Rate.");
        this.menuItemSaveMueMatrix = this.createMenuItem(this.menuTables, 0, "Export Execution Rates Statistics", null, 77, null);
        this.menuItemSaveMueMatrix.setToolTipText("Use this option to export statistics about the execution rates of server for each job class.");
        this.menuItemSaveJobTable = this.createMenuItem(this.menuTables, 0, "Export Job Table", null, 74, null);
        this.menuItemSaveJobTable.setToolTipText("Use this option to export a table that has statistics about each individual job.");
        this.menuTables.addSeparator();
        this.menuItemSaveAll = this.createMenuItem(this.menuTables, 0, "Export All", null, 65, null);
        this.menuItemSaveAll.setToolTipText("Use this option to export the following: Generic Statistics, Job Classes Statistics, Execution Rates and Job Table.");
        this.menuBar.add(this.menuTables);
        this.menuServers = new JMenu("Servers");
        this.menuServers.setMnemonic('S');
        this.menuItemStartServers = this.createMenuItem(this.menuServers, 0, "Start Servers", null, 83, null);
        this.menuItemPingServers = this.createMenuItem(this.menuServers, 0, "Ping Servers", null, 78, null);
        this.menuItemPauseServers = this.createMenuItem(this.menuServers, 0, "Pause Servers", null, 80, null);
        this.menuItemKillServers = this.createMenuItem(this.menuServers, 0, "Kill Servers", null, 75, null);
        this.menuBar.add(this.menuServers);
        this.menuHelp = new JMenu("Help");
        this.menuHelp.setMnemonic('H');
        this.menuItemManual = this.createMenuItem(this.menuHelp, 0, "User Manual", null, 65, null);
        this.menuItemThesis = this.createMenuItem(this.menuHelp, 0, "Thesis Document", null, 65, null);
        this.menuBar.add(this.menuHelp);
        this.menuAbout = new JMenu("About");
        this.menuAbout.setMnemonic('A');
        this.menuItemAbout = this.createMenuItem(this.menuAbout, 0, "About", null, 72, null);
        this.menuBar.add(this.menuAbout);
    }

    public JMenuItem createMenuItem(JMenu menu, int iType, String sText, ImageIcon image, int acceleratorKey, String sToolTip) {
        JMenuItem menuItem;
        switch (iType) {
            case 2: {
                menuItem = new JRadioButtonMenuItem();
                break;
            }
            case 1: {
                menuItem = new JCheckBoxMenuItem();
                break;
            }
            default: {
                menuItem = new JMenuItem();
            }
        }
        menuItem.setText(sText);
        if (image != null) {
            menuItem.setIcon(image);
        }
        if (acceleratorKey > 0) {
            menuItem.setMnemonic(acceleratorKey);
        }
        if (sToolTip != null) {
            menuItem.setToolTipText(sToolTip);
        }
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menuItem;
    }

    public void buildJobClasses() throws IOException {
        this.setReadFile("genericclasses.txt");
        JobClassesTable table = new JobClassesTable();
        BufferedReader file = new BufferedReader(new FileReader(this.getReadFile()));
        try {
            String currentLine;
            while ((currentLine = file.readLine()) != null) {
                int endofAR = 0;
                while (currentLine.charAt(endofAR++) != ';') {
                }
                String ar = currentLine.substring(0, endofAR - 1).trim();
                double ArrivalRate = Double.parseDouble(ar);
                String iter = currentLine.substring(endofAR).trim();
                long executionTime = Long.parseLong(iter);
                table.addJobClass(ArrivalRate, executionTime);
            }
            this.getMapper().setClassesTable(table);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void buildServers() {
        ServersTable serversTable = new ServersTable();
        try {
            ServersReader.readServersFromFile("Servers/servers.srs", serversTable);
        }
        catch (Exception ex) {
            this.getMapper().setServersTable(new ServersTable());
            return;
        }
        this.getMapper().setServersTable(serversTable);
        this.getMapper().fillProcessingRates();
    }

    public static MainFrame creatMainFrame() {
        MainFrame frame = new MainFrame();
        frame.setDefaultCloseOperation(0);
        frame.setSize(1024, 786);
        frame.setTitle("McMaster Grid Scheduling Testing Environment");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - frame.getWidth() / 2, screenSize.height / 2 - frame.getHeight() / 2);
        return frame;
    }

    private void startGenerators() {
        this.getGeneratorsController().startGenerators();
    }

    private void stopGenerators() {
        this.getGeneratorsController().stopGenerators();
    }

    private void start() {
        this.getMapper().startMapper();
        this.startGenerators();
        this.availabilityServer.startServer();
        this.completionServer.startServer();
        this.savingRunnable.startThread();
        this.startJButton.setEnabled(false);
        this.menuItemStart.setEnabled(false);
        this.stopJButton.setEnabled(true);
        this.menuItemStop.setEnabled(true);
        this.saveJButton.setEnabled(false);
        this.loadJButton.setEnabled(false);
        this.fillProcessingRate.setEnabled(false);
        this.failureTraceButton.setEnabled(false);
        this.serversTableJPanel.disableInput();
        this.jobClassesTableJPanel.disableInput();
        this.jobClassesJPanel.setEnabled(true);
        this.availableServersJPanel.setModelForJTable(this.getMapper().getAvailableServersQueue());
    }

    private void stop() {
        this.getMapper().stopMapper();
        this.stopGenerators();
        this.availabilityServer.stopServer();
        this.completionServer.stopServer();
        this.startJButton.setEnabled(true);
        this.menuItemStart.setEnabled(true);
        this.stopJButton.setEnabled(false);
        this.menuItemStop.setEnabled(false);
        this.saveJButton.setEnabled(true);
        this.loadJButton.setEnabled(true);
        this.fillProcessingRate.setEnabled(true);
        this.failureTraceButton.setEnabled(true);
        this.serversTableJPanel.enableInput();
        this.jobClassesTableJPanel.enableInput();
        this.savingRunnable.stopThread();
    }

    /*
     * Loose catch block
     */
    public void sendStartMessages() {
        Socket mapperSocket = null;
        FilterOutputStream out = null;
        int port = 37934;
        int i = 0;
        int size = this.mapper.getServersTable().size();
        ProgressBarFrame progressFrame = new ProgressBarFrame("Servers Started", size);
        i = 0;
        while (i < size) {
            block36: {
                block38: {
                    try {
                        mapperSocket = new Socket(this.mapper.getServer(i + 1).getHostName(), port);
                        out = new DataOutputStream(mapperSocket.getOutputStream());
                        String s = "start#" + this.mapper.getTimeResolution() + "#" + this.mapper.getMapperHostName() + "#" + this.getMapper().getServer(i + 1).getLastMessageSent().toString();
                        System.out.print("Message: " + s);
                        ((DataOutputStream)out).writeBytes(s);
                        ((DataOutputStream)out).flush();
                        progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " started successfully.");
                        progressFrame.repaint();
                        System.out.println("sendStartMessages: " + s);
                    }
                    catch (ConnectException e) {
                        progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " refuses the connection. Puller software might not be working.");
                        if (mapperSocket != null) {
                            try {
                                mapperSocket.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                                ((DataOutputStream)out).flush();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                        break block36;
                    }
                    catch (UnknownHostException e1) {
                        progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " is Unknownhost.");
                        break block36;
                    }
                    catch (IOException e1) {
                        block37: {
                            progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " IOException.");
                            if (mapperSocket == null) break block37;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            try {
                                mapperSocket.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                                ((DataOutputStream)out).flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block36;
                    }
                    {
                        finally {
                            if (mapperSocket != null) {
                                try {
                                    mapperSocket.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (out != null) {
                                try {
                                    out.close();
                                    ((DataOutputStream)out).flush();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (mapperSocket == null) break block38;
                    try {
                        mapperSocket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                        ((DataOutputStream)out).flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    /*
     * Loose catch block
     */
    public void sendPingMessages() {
        Socket mapperSocket = null;
        FilterOutputStream out = null;
        int port = 37934;
        int i = 0;
        int size = this.mapper.getServersTable().size();
        ProgressBarFrame progressFrame = new ProgressBarFrame("Servers Ping", size);
        i = 0;
        while (i < size) {
            block45: {
                block47: {
                    mapperSocket = new Socket();
                    InetSocketAddress server = new InetSocketAddress(this.mapper.getServer(i + 1).getHostName().trim(), port);
                    try {
                        mapperSocket.connect(server, 2000);
                    }
                    catch (SocketTimeoutException ex) {
                        progressFrame.changeProgress(i + 1, "Server (" + this.mapper.getServer(i + 1).getHostName().trim() + ") timed out the connection.");
                        if (mapperSocket != null) {
                            try {
                                mapperSocket.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                                ((DataOutputStream)out).flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block45;
                    }
                    try {
                        out = new DataOutputStream(mapperSocket.getOutputStream());
                        String s = "ping";
                        ((DataOutputStream)out).writeBytes(s);
                        ((DataOutputStream)out).flush();
                        progressFrame.changeProgress(i + 1, "Server " + this.mapper.getServer(i + 1).getHostName().trim() + " Pinged successfully.");
                    }
                    catch (ConnectException e) {
                        progressFrame.changeProgress(i + 1, "Server (" + this.mapper.getServer(i + 1).getHostName().trim() + ") refuses the connection. Puller software might not be working.");
                        e.printStackTrace();
                        if (mapperSocket != null) {
                            try {
                                mapperSocket.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                                ((DataOutputStream)out).flush();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                        break block45;
                    }
                    catch (UnknownHostException e1) {
                        progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " is Unknownhost.");
                        break block45;
                    }
                    catch (IOException e12) {
                        block46: {
                            progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " IOException.");
                            if (mapperSocket == null) break block46;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            try {
                                mapperSocket.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                                ((DataOutputStream)out).flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block45;
                    }
                    {
                        finally {
                            if (mapperSocket != null) {
                                try {
                                    mapperSocket.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (out != null) {
                                try {
                                    out.close();
                                    ((DataOutputStream)out).flush();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (mapperSocket == null) break block47;
                    try {
                        mapperSocket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                        ((DataOutputStream)out).flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    /*
     * Loose catch block
     */
    public void sendRestartMessages() {
        Socket mapperSocket = null;
        FilterOutputStream out = null;
        int port = 37934;
        int i = 0;
        int size = this.mapper.getServersTable().size();
        ProgressBarFrame progressFrame = new ProgressBarFrame("Servers Restart", size);
        i = 0;
        while (i < size) {
            block36: {
                block38: {
                    try {
                        mapperSocket = new Socket(this.mapper.getServer(i + 1).getHostName(), port);
                        out = new DataOutputStream(mapperSocket.getOutputStream());
                        String s = "restart";
                        ((DataOutputStream)out).writeBytes(s);
                        ((DataOutputStream)out).flush();
                        progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " paused successfully.");
                    }
                    catch (ConnectException e) {
                        progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " refuses the connection. Puller software might not be working.");
                        e.printStackTrace();
                        if (mapperSocket != null) {
                            try {
                                mapperSocket.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                                ((DataOutputStream)out).flush();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                        break block36;
                    }
                    catch (UnknownHostException e1) {
                        progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " is Unknownhost.");
                        break block36;
                    }
                    catch (IOException e1) {
                        block37: {
                            progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " IOException.");
                            if (mapperSocket == null) break block37;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            try {
                                mapperSocket.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                                ((DataOutputStream)out).flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block36;
                    }
                    {
                        finally {
                            if (mapperSocket != null) {
                                try {
                                    mapperSocket.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (out != null) {
                                try {
                                    out.close();
                                    ((DataOutputStream)out).flush();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (mapperSocket == null) break block38;
                    try {
                        mapperSocket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                        ((DataOutputStream)out).flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    /*
     * Loose catch block
     */
    public void sendStopMessages() {
        Socket mapperSocket = null;
        FilterOutputStream out = null;
        int port = 37934;
        int i = 0;
        int size = this.mapper.getServersTable().size();
        ProgressBarFrame progressFrame = new ProgressBarFrame("Servers Stop", size);
        i = 0;
        while (i < size) {
            block36: {
                block38: {
                    try {
                        mapperSocket = new Socket(this.mapper.getServer(i + 1).getHostName(), port);
                        out = new DataOutputStream(mapperSocket.getOutputStream());
                        String s = "stop";
                        ((DataOutputStream)out).writeBytes(s);
                        ((DataOutputStream)out).flush();
                        progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " stopped successfully.");
                    }
                    catch (ConnectException e) {
                        progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " refuses the connection. Puller software might not be working.");
                        e.printStackTrace();
                        if (mapperSocket != null) {
                            try {
                                mapperSocket.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                                ((DataOutputStream)out).flush();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                        break block36;
                    }
                    catch (UnknownHostException e1) {
                        progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " is Unknownhost.");
                        break block36;
                    }
                    catch (IOException e1) {
                        block37: {
                            progressFrame.changeProgress(i + 1, "Server " + (i + 1) + " IOException.");
                            if (mapperSocket == null) break block37;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            try {
                                mapperSocket.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                                ((DataOutputStream)out).flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block36;
                    }
                    {
                        finally {
                            if (mapperSocket != null) {
                                try {
                                    mapperSocket.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (out != null) {
                                try {
                                    out.close();
                                    ((DataOutputStream)out).flush();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (mapperSocket == null) break block38;
                    try {
                        mapperSocket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                        ((DataOutputStream)out).flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser;
        Runtime runtime;
        String command;
        if (e.getSource() == this.startJButton || e.getSource() == this.menuItemStart) {
            this.start();
            return;
        }
        if (e.getSource() == this.stopJButton || e.getSource() == this.menuItemStop) {
            this.stop();
            return;
        }
        if (e.getSource() == this.saveJButton || e.getSource() == this.menuItemSaveDefinitions) {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal != 0) {
                return;
            }
            this.getMapper().saveMapperAsObjects(String.valueOf(chooser.getSelectedFile().getAbsolutePath()) + ".def");
            return;
        }
        if (e.getSource() == this.loadJButton || e.getSource() == this.menuItemLoadDefinitions) {
            ExtensionFileFilter filter = new ExtensionFileFilter("DEF", new String[]{"DEF"});
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal != 0) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.getMapper().readMapperAsObjects(chooser.getSelectedFile().getAbsolutePath());
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.serversTableJPanel.fillJTable();
            this.serversTableJPanel.showServerInfo();
            this.jobClassesTableJPanel.fillJTable();
            this.serversAvailabilityPanel.fillJTable();
            this.systemLevelParametersJPanel.refreshValues();
            this.getMapper().getServersTable().addServersListener(this.serversTableJPanel);
            this.getMapper().getJobsTable().addJobsTableListener(this.jobsTableJPanel);
            return;
        }
        if (e.getSource() == this.printMapperJButton || e.getSource() == this.menuItemPrint) {
            this.getMapper().printAvailabilityQueue();
            System.out.println("-------------");
            this.getMapper().printServers();
            System.out.flush();
            System.err.flush();
            this.getMapper().print();
            return;
        }
        if (e.getSource() == this.failureTraceButton || e.getSource() == this.menuItemProcessingRates) {
            this.getMapper().fillAllFailureTraces(this.getMapper().getFailurePeriodsMean(), this.getMapper().getUpTimePeriodsMean());
            this.serversTableJPanel.showServerInfo();
            return;
        }
        if (e.getSource() == this.fillProcessingRate || e.getSource() == this.menuItemFailureTraces) {
            this.mapper.fillProcessingRates();
            this.serversTableJPanel.showServerInfo();
            return;
        }
        if (e.getSource() == this.startServers || e.getSource() == this.menuItemStartServers) {
            this.sendStartMessages();
            return;
        }
        if (e.getSource() == this.menuItemPingServers) {
            this.sendPingMessages();
            return;
        }
        if (e.getSource() == this.pauseServers || e.getSource() == this.menuItemPauseServers) {
            this.sendRestartMessages();
            return;
        }
        if (e.getSource() == this.killServers || e.getSource() == this.menuItemKillServers) {
            this.sendStopMessages();
            return;
        }
        if (e.getSource() == this.menuItemManual) {
            command = null;
            if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
                command = "open ./userManual.pdf";
            }
            if (System.getProperty("os.name").startsWith("Windows")) {
                command = "\"userManual.pdf\"";
            }
            runtime = Runtime.getRuntime();
            try {
                runtime.exec(command);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (e.getSource() == this.menuItemThesis) {
            command = null;
            if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
                command = "open ./thesis.pdf";
            }
            if (System.getProperty("os.name").startsWith("Windows")) {
                command = "\"thesis.pdf\"";
            }
            runtime = Runtime.getRuntime();
            try {
                runtime.exec(command);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (e.getSource() == this.menuItemAbout) {
            JOptionPane.showMessageDialog(this, "McMaster Grid Scheduling Testing Environment\n\u00a9 June 2008, McMaster University, Copyrights reserved", "MGST", 1);
        }
        if (e.getSource() == this.menuItemSaveSystemStats) {
            fileChooser = new JFileChooser();
            int returnedValue = fileChooser.showSaveDialog(this);
            if (returnedValue != 0) {
                return;
            }
            Reporter.generateReportAboutSystemStatistics(this.getMapper(), fileChooser.getSelectedFile().getAbsolutePath());
        }
        if (e.getSource() == this.menuItemSaveJobClassesStats) {
            fileChooser = new JFileChooser();
            int returnedValue = fileChooser.showSaveDialog(this);
            if (returnedValue != 0) {
                return;
            }
            try {
                Reporter.generateReportAboutJobClasses(this.getMapper(), this.getGeneratorsController(), fileChooser.getSelectedFile().getAbsolutePath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (e.getSource() == this.menuItemSaveMueMatrix) {
            fileChooser = new JFileChooser();
            int returnedValue = fileChooser.showSaveDialog(this);
            if (returnedValue != 0) {
                return;
            }
            try {
                Reporter.generateReportOfMue(this.getMapper(), fileChooser.getSelectedFile().getAbsolutePath());
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, "Could not save!", "Could not save!", 0);
            }
        }
        if (e.getSource() == this.menuItemSaveJobTable) {
            fileChooser = new JFileChooser();
            int returnVal = fileChooser.showSaveDialog(this);
            if (returnVal != 0) {
                return;
            }
            this.getMapper().getJobsTable().saveToFile(fileChooser.getSelectedFile().getAbsolutePath());
        }
        if (e.getSource() == this.menuItemSaveAll) {
            fileChooser = new JFileChooser();
            int returnedValue = fileChooser.showSaveDialog(this);
            if (returnedValue != 0) {
                return;
            }
            try {
                Reporter.generateReportAboutSystemStatistics(this.getMapper(), String.valueOf(fileChooser.getSelectedFile().getAbsolutePath()) + "_systemStats.txt");
                Reporter.generateReportAboutJobClasses(this.getMapper(), this.getGeneratorsController(), String.valueOf(fileChooser.getSelectedFile().getAbsolutePath()) + "_classesStats.txt");
                Reporter.generateReportOfMue(this.getMapper(), String.valueOf(fileChooser.getSelectedFile().getAbsolutePath()) + "_mue.txt");
                this.getMapper().getJobsTable().saveToFile(String.valueOf(fileChooser.getSelectedFile().getAbsolutePath()) + "_jobs.txt");
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, "Could not save!", "Could not save!", 0);
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.setVisible(true);
    }

    public void windowClosing(WindowEvent e) {
        int result = JOptionPane.showConfirmDialog(this, "Are you sure?", "Exit", 0, 0);
        if (result == 0) {
            System.exit(1);
        }
        this.setSize(1024, 786);
        this.setTitle("McMaster Grid Scheduling Testing Environment (MGST)");
        this.setVisible(true);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

