/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import interfacing.ProcessingRatesTableModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import mapping.Mapper;

public class ServersProcessingRatesTableModelListener
implements TableModelListener {
    private Mapper mapper;
    private int serverID;

    public ServersProcessingRatesTableModelListener(Mapper mapper, int id) {
        this.setMapper(mapper);
        this.setServerID(id);
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public int getServerID() {
        return this.serverID;
    }

    public void setServerID(int serverID) {
        this.serverID = serverID;
    }

    public void tableChanged(TableModelEvent e) {
        double d;
        ProcessingRatesTableModel model = (ProcessingRatesTableModel)e.getSource();
        if (e.getColumn() == 1) {
            d = 0.0;
            try {
                d = Double.parseDouble(((String)model.getValueAt(e.getFirstRow(), e.getColumn())).trim());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(new JFrame(), "Please insert a valid rate value.", "Error", 0);
                model.setValueAt(String.valueOf(this.getMapper().getRealRate(this.getServerID(), e.getFirstRow() + 1)), e.getFirstRow(), e.getColumn());
                return;
            }
            System.out.print("Server: " + this.getServerID() + "Class " + e.getFirstRow() + 1 + "rate " + d);
            this.getMapper().setRealRate(this.getServerID(), e.getFirstRow() + 1, d);
        }
        if (e.getColumn() == 2) {
            d = 0.0;
            try {
                d = Double.parseDouble(((String)model.getValueAt(e.getFirstRow(), e.getColumn())).trim());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(new JFrame(), "Please insert a valid rate value.", "Error", 0);
                model.setValueAt(String.valueOf(this.getMapper().getAssumedRate(this.getServerID(), e.getFirstRow() + 1)), e.getFirstRow(), e.getColumn());
                return;
            }
            this.getMapper().setAssumedRate(this.getServerID(), e.getFirstRow() + 1, d);
        }
    }
}

