/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import logging.Logger;
import mapping.Mapper;
import mapping.data.Server;

public class AvailabilityServer
implements Runnable {
    private boolean alive = true;
    private int availablityPort = 37933;
    private Mapper mapper;
    private Logger logger;
    private Thread thisThread;
    ServerSocket serverSocket = null;
    Socket socket = null;
    DataInputStream in = null;

    public AvailabilityServer(Mapper mapper) {
        this.setMapper(mapper);
        this.setLogger(new Logger("AvailabilityServer"));
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public int getAvailablityPort() {
        return this.availablityPort;
    }

    public void setAvailablityPort(int availablityPort) {
        this.availablityPort = availablityPort;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void startServer() {
        this.setAlive(true);
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopServer() {
        boolean wasAlive = this.isAlive();
        this.setAlive(false);
        if (wasAlive) {
            this.thisThread.interrupt();
            this.thisThread = null;
        }
    }

    public void run() {
        this.setAlive(true);
        String hostname = new String();
        String availability = new String();
        try {
            this.serverSocket = new ServerSocket(this.getAvailablityPort());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        while (this.isAlive()) {
            block37: {
                block38: {
                    hostname = "";
                    availability = "";
                    System.out.println("Availability Server is waiting...");
                    this.socket = this.serverSocket.accept();
                    if (this.isAlive()) break block37;
                    if (this.in == null) break block38;
                    try {
                        this.in.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
            try {
                try {
                    int r;
                    this.in = new DataInputStream(this.socket.getInputStream());
                    System.out.println("Availability Server received a message: ");
                    while ((r = this.in.read()) != -1 && r != 35) {
                        hostname = String.valueOf(hostname) + (char)r;
                    }
                    while ((r = this.in.read()) != -1 && r != 35) {
                        availability = String.valueOf(availability) + (char)r;
                    }
                    this.getLogger().log("Availability received from (" + hostname + ") as (" + availability + ")");
                    Server s = null;
                    if (this.getMapper() != null) {
                        if (this.getMapper().getServersTable() != null) {
                            s = this.getMapper().getServersTable().getServer(hostname);
                        } else {
                            System.err.println("ServersTable() not init");
                        }
                    } else {
                        System.err.println("Mapper not init");
                    }
                    if (s != null) {
                        s.setAvailabilty(Double.parseDouble(availability));
                    } else {
                        System.err.println("Server is not initialized");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (this.socket == null) continue;
                    try {
                        this.socket.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (this.socket == null) continue;
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

