/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import mapping.FCFS_MS_Thread;
import mapping.Mapper;
import mapping.MappingScheme;
import mapping.data.IDsQueue;
import mapping.data.Job;

public class FCFS_MS
extends MappingScheme {
    private static final long serialVersionUID = 6935102166481580800L;
    private IDsQueue<Long> serviceQueue;
    private FCFS_MS_Thread fifo_ms_thread;
    static final int NO_JOBS = -100;

    public FCFS_MS(Mapper mapper) {
        super(mapper);
        this.setDescription("FCFS");
    }

    public void startMappingScheme() {
        this.serviceQueue = new IDsQueue();
        this.fifo_ms_thread = new FCFS_MS_Thread(this);
        this.fifo_ms_thread.startThread();
    }

    public void stopMappingScheme() {
        this.fifo_ms_thread.stopThread();
    }

    protected void mapJob(Job job) {
        this.serviceQueue.enqueue(job.getIndex());
    }

    public void handleJobTimeOut(long jobID) {
        this.getMapper().getJobsTable().setTimedOut(jobID, true);
        this.getMapper().getJobsTable().setJobServer(jobID, null);
        this.getMapper().resubmitJob((Job)this.getMapper().getJobsTable().get(jobID));
    }

    public void serverIsDown(int serverID) {
    }

    public void serverIsUp(int serverID) {
    }

    protected int sendJobForServer(int serverID) {
        if (this.serviceQueue.isEmpty()) {
            return -100;
        }
        long jobID = this.serviceQueue.peak();
        long result = this.getMapper().sendJob(jobID, serverID);
        if (result >= 0L) {
            System.out.println("FCFS.sendJobForServer(): WAS sent " + jobID);
            this.serviceQueue.dequeue();
            return 1;
        }
        return -1;
    }
}

