/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import java.util.GregorianCalendar;
import logging.Logger;
import mapping.LPAS_DG_MS;

public class LPAS_DG_MS_SOLVING_TICKER
implements Runnable {
    private boolean alive = true;
    private Thread thisThread;
    LPAS_DG_MS lpas_dg_ms;
    private double secondsAfterSystemTickToSolve = 30.0;
    private Logger logger;

    public LPAS_DG_MS_SOLVING_TICKER(LPAS_DG_MS lpas_dg) {
        this.setLpas_dg(lpas_dg);
        this.setLogger(new Logger("lpas_resolving"));
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public LPAS_DG_MS getLpas_dg() {
        return this.lpas_dg_ms;
    }

    public void setLpas_dg(LPAS_DG_MS lpas_dg_ms) {
        this.lpas_dg_ms = lpas_dg_ms;
    }

    public double getSecondsAfterSystemTickToSolve() {
        return this.secondsAfterSystemTickToSolve;
    }

    public void setSecondsAfterSystemTickToSolve(double secondsAfterSystemTickToSolve) {
        this.secondsAfterSystemTickToSolve = secondsAfterSystemTickToSolve;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void startThread() {
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.getLogger().closeStreams();
        this.thisThread.interrupt();
        this.thisThread = null;
    }

    public void run() {
        while (this.isAlive()) {
            block3: {
                try {
                    Thread.sleep((long)((double)this.getSleepTimeTillNextSystemTick() + this.getSecondsAfterSystemTickToSolve() * 1000.0));
                }
                catch (InterruptedException e) {
                    if (this.isAlive()) break block3;
                    return;
                }
            }
            this.getLpas_dg().refreshDeltaStar();
            this.getLogger().log("LPAS_DG delta matrix resolved: delta: " + this.getLpas_dg().getDeltaStar().toString());
        }
    }

    private long getSleepTimeTillNextSystemTick() {
        double tickLengthInMinutes = this.getLpas_dg().getMapper().getTimeResolution();
        GregorianCalendar beginningOfDay = new GregorianCalendar();
        beginningOfDay.set(11, 0);
        beginningOfDay.set(12, 0);
        beginningOfDay.set(13, 0);
        beginningOfDay.set(14, 0);
        GregorianCalendar now = new GregorianCalendar();
        long diff = now.getTimeInMillis() - beginningOfDay.getTimeInMillis();
        double ticksInDiff = (double)diff / (tickLengthInMinutes * 60.0 * 1000.0);
        double sleepTime = (Math.ceil(ticksInDiff) - ticksInDiff) * tickLengthInMinutes * 60.0 * 1000.0;
        return this.min(Math.round(sleepTime), this.getTimeTillMidnight(now));
    }

    public long getSleepTimeTillNextSystemTick2(GregorianCalendar time) {
        double tickLengthInMinutes = this.getLpas_dg().getMapper().getTimeResolution();
        GregorianCalendar beginningOfDay = new GregorianCalendar();
        beginningOfDay.set(11, 0);
        beginningOfDay.set(12, 0);
        beginningOfDay.set(13, 0);
        beginningOfDay.set(14, 0);
        long diff = time.getTimeInMillis() - beginningOfDay.getTimeInMillis();
        double ticksInDiff = (double)diff / (tickLengthInMinutes * 60.0 * 1000.0);
        double sleepTime = (Math.ceil(ticksInDiff) - ticksInDiff) * tickLengthInMinutes * 60.0 * 1000.0;
        return this.min(Math.round(sleepTime), this.getTimeTillMidnight(time));
    }

    private long getTimeTillMidnight(GregorianCalendar cal) {
        GregorianCalendar nextMidnight = (GregorianCalendar)cal.clone();
        nextMidnight.set(11, 0);
        nextMidnight.set(12, 0);
        nextMidnight.set(13, 0);
        nextMidnight.set(14, 0);
        nextMidnight.set(5, cal.get(5) + 1);
        return nextMidnight.getTimeInMillis() - cal.getTimeInMillis();
    }

    private long min(long a, long b) {
        if (a <= b) {
            return a;
        }
        return b;
    }
}

