/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import drasys.or.matrix.Vect;
import drasys.or.mp.Problem;
import drasys.or.mp.lp.DenseSimplex;
import mapping.data.DeltaStar;
import mapping.data.JobClass;
import mapping.data.JobClassesTable;
import mapping.data.Server;
import mapping.data.ServersTable;

public class LP_Solver {
    static final String LAMBDA = "lambda";
    static final String DELTA = "delta";
    static final double epsylon = 7.0E-6;

    public static DeltaStar solveWithAj(ServersTable serversTable, JobClassesTable jobClassesTable) throws Exception {
        int classesNumber = 0;
        int serversNumber = 0;
        try {
            classesNumber = jobClassesTable.size();
            serversNumber = serversTable.size();
        }
        catch (NullPointerException e) {
            System.err.print("Error: Invalid input in method LP_Solver.solve()");
            e.printStackTrace();
            return null;
        }
        Problem prob = new Problem(classesNumber + serversNumber, 1 + classesNumber * serversNumber);
        prob.getMetadata().put("lp.isMaximize", "true");
        int LTE = 11;
        int GTE = 12;
        prob.newVariable(LAMBDA).setObjectiveCoefficient(1.0);
        int i = 0;
        while (i < classesNumber) {
            JobClass currentJobClass = (JobClass)jobClassesTable.get(i + 1);
            prob.newConstraint("c" + i).setType((byte)12).setRightHandSide(0.0);
            int j = 0;
            while (j < serversNumber) {
                prob.newVariable(DELTA + i + "_" + j).setLowerBound(0.0);
                prob.getVariable(DELTA + i + "_" + j).setUpperBound(1.0);
                prob.setCoefficientAt("c" + i, DELTA + i + "_" + j, ((Server)serversTable.get(j + 1)).getProcessingRate(currentJobClass.getIndex()).getAssumedRate());
                ++j;
            }
            prob.setCoefficientAt("c" + i, LAMBDA, currentJobClass.getArrivalRate() * -1.0);
            ++i;
        }
        while (i < classesNumber + serversNumber) {
            prob.newConstraint("c" + i).setType((byte)11).setRightHandSide(((Server)serversTable.get(i + 1 - classesNumber)).getAvailability());
            ++i;
        }
        int k = 0;
        while (k < serversNumber) {
            int l = 0;
            while (l < classesNumber) {
                prob.setCoefficientAt("c" + (classesNumber + k), DELTA + l + "_" + k, 1.0);
                ++l;
            }
            ++k;
        }
        DenseSimplex lp = new DenseSimplex(prob);
        double lamda = lp.solve();
        Vect solution = (Vect)lp.getSolution();
        DeltaStar deltaStar = new DeltaStar(serversNumber);
        int l = 0;
        while (l < classesNumber) {
            int k2 = 0;
            while (k2 < serversNumber) {
                double e = solution.elementAt(l * serversNumber + k2 + 1);
                if (e < 7.0E-6 && e > -7.0E-6) {
                    deltaStar.addZero(l, k2);
                }
                ++k2;
            }
            ++l;
        }
        deltaStar.setLambdaStart(lamda);
        return deltaStar;
    }

    public static Object[] solveWithAjAndReturnFullDeltaStar(ServersTable serversTable, JobClassesTable jobClassesTable) throws Exception {
        int classesNumber = 0;
        int serversNumber = 0;
        try {
            classesNumber = jobClassesTable.size();
            serversNumber = serversTable.size();
        }
        catch (NullPointerException e) {
            System.err.print("Error: Invalid input in method LP_Solver.solve()");
            e.printStackTrace();
            return null;
        }
        Problem prob = new Problem(classesNumber + serversNumber, 1 + classesNumber * serversNumber);
        prob.getMetadata().put("lp.isMaximize", "true");
        int LTE = 11;
        int GTE = 12;
        prob.newVariable(LAMBDA).setObjectiveCoefficient(1.0);
        int i = 0;
        while (i < classesNumber) {
            JobClass currentJobClass = (JobClass)jobClassesTable.get(i + 1);
            prob.newConstraint("c" + i).setType((byte)12).setRightHandSide(0.0);
            int j = 0;
            while (j < serversNumber) {
                prob.newVariable(DELTA + i + "_" + j).setLowerBound(0.0);
                prob.getVariable(DELTA + i + "_" + j).setUpperBound(1.0);
                prob.setCoefficientAt("c" + i, DELTA + i + "_" + j, ((Server)serversTable.get(j + 1)).getProcessingRate(currentJobClass.getIndex()).getAssumedRate());
                ++j;
            }
            prob.setCoefficientAt("c" + i, LAMBDA, currentJobClass.getArrivalRate() * -1.0);
            ++i;
        }
        while (i < classesNumber + serversNumber) {
            prob.newConstraint("c" + i).setType((byte)11).setRightHandSide(((Server)serversTable.get(i + 1 - classesNumber)).getAvailability());
            ++i;
        }
        int k = 0;
        while (k < serversNumber) {
            int l = 0;
            while (l < classesNumber) {
                prob.setCoefficientAt("c" + (classesNumber + k), DELTA + l + "_" + k, 1.0);
                ++l;
            }
            ++k;
        }
        DenseSimplex lp = new DenseSimplex(prob);
        double lamda = lp.solve();
        Vect solution = (Vect)lp.getSolution();
        double[][] fullDeltaStar = new double[classesNumber][serversNumber];
        int l = 0;
        while (l < classesNumber) {
            int k2 = 0;
            while (k2 < serversNumber) {
                fullDeltaStar[l][k2] = solution.elementAt(l * serversNumber + k2 + 1);
                ++k2;
            }
            ++l;
        }
        Object[] objects = new Object[]{fullDeltaStar, new Double(lamda)};
        return objects;
    }
}

