/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import mapping.SLQ_MS;
import mapping.data.IDsQueue;
import mapping.data.Server;

public class SLQ_MS_Thread
implements Runnable {
    private boolean alive = true;
    private Thread thisThread;
    private SLQ_MS slq_ms;

    public SLQ_MS_Thread(SLQ_MS slq_ms) {
        this.setAlive(true);
        this.setSLQ_MS(slq_ms);
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public SLQ_MS getSLQ_MS() {
        return this.slq_ms;
    }

    public void setSLQ_MS(SLQ_MS slq_ms) {
        this.slq_ms = slq_ms;
    }

    public void startThread() {
        System.out.println("LPAS Thread started");
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.thisThread.interrupt();
        this.thisThread = null;
    }

    public void run() {
        Server server = null;
        IDsQueue<Integer> q = this.getSLQ_MS().getMapper().getAvailableServersQueue();
        while (this.isAlive()) {
            if (q.isEmpty()) continue;
            int serverID = q.peak();
            server = (Server)this.getSLQ_MS().getMapper().getServersTable().get(serverID);
            if (server.getNumberOfActiveJobs() == 0 && !this.getSLQ_MS().getMapper().getServersTable().isServerDown(serverID)) {
                int result = this.getSLQ_MS().sendJobForServer(serverID);
                if (result >= 0) continue;
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    if (this.isAlive()) continue;
                    return;
                }
            }
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

