/*
 * Decompiled with CFR 0.152.
 */
package mapping.data;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import mapping.data.Job;
import mapping.data.JobsTableListener;
import mapping.data.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobsTable
extends Hashtable<Long, Job> {
    private static final long serialVersionUID = -3000311390159709455L;
    private long jobID = 1L;
    private JobsTableListener listener;
    public static int CLOCK_DIFFERENCE_TOLARNCE = 3;

    public JobsTable(int initialCapacity) {
        super(initialCapacity);
    }

    public void addJob(Job job) {
        job.setIndex(this.jobID++);
        job.setTimeSubmitted(new GregorianCalendar());
        this.put(job.getIndex(), job);
        if (this.listener != null) {
            this.listener.jobHasBeenAdded(job.getIndex(), job.getSecondaryID(), job.getJobClassID(), "", job.getTimeSubmitted(), job.getTimeSent(), job.getTimeStarted(), job.getTimeDone(), job.getStatus(), job.isTimedOut());
        }
    }

    public void printAll() {
        System.out.println(this.toString());
    }

    public boolean isJobTimedOut(long l) {
        return ((Job)this.get(l)).isTimedOut();
    }

    public String getJobHostName(long l) {
        return ((Job)this.get(l)).getServer().getHostName();
    }

    public long getJobIndex(long l) {
        return ((Job)this.get(l)).getIndex();
    }

    public long getJobSecondaryID(long l) {
        return ((Job)this.get(l)).getSecondaryID();
    }

    public int getJobClassID(long l) {
        return ((Job)this.get(l)).getJobClassID();
    }

    public long getJobexecutionTime(long l) {
        return ((Job)this.get(l)).getexecutionTime();
    }

    public Server getJobServer(long l) {
        return ((Job)this.get(l)).getServer();
    }

    public String getJobStatus(long l) {
        return ((Job)this.get(l)).getStatus();
    }

    public GregorianCalendar getJobTimeSubmitted(long l) {
        return ((Job)this.get(l)).getTimeSubmitted();
    }

    public GregorianCalendar getJobTimeSent(long l) {
        return ((Job)this.get(l)).getTimeSent();
    }

    public GregorianCalendar getJobTimeStarted(long l) {
        return ((Job)this.get(l)).getTimeStarted();
    }

    public GregorianCalendar getJobTimeDone(long l) {
        return ((Job)this.get(l)).getTimeDone();
    }

    public boolean getJobIsTimedOut(long l) {
        return ((Job)this.get(l)).isTimedOut();
    }

    public void setJobSecondaryID(long id, long secondID) {
        ((Job)this.get(id)).setSecondaryID(secondID);
        if (this.listener != null) {
            this.listener.secondaryIDHasBeenChanged(id, secondID);
        }
    }

    public void setJobClassID(long id, int classID) {
        ((Job)this.get(id)).setJobClassID(classID);
        if (this.listener != null) {
            this.listener.jobClassIDHasBeenChanged(id, classID);
        }
    }

    public void setJobServer(long id, Server server) {
        ((Job)this.get(id)).setServer(server);
        if (this.listener != null) {
            if (server != null) {
                this.listener.serverNameHasBeenChanged(id, server.getHostName());
                this.listener.serverIDHasBeenChanged(id, server.getIndex());
            } else {
                this.listener.serverNameHasBeenChanged(id, "");
                this.listener.serverIDHasBeenChanged(id, -1);
            }
        }
    }

    public void setJobTimeSubmitted(long id, GregorianCalendar cal) {
        ((Job)this.get(id)).setTimeSubmitted(cal);
        if (this.listener != null) {
            this.listener.timeSubmittedHasBeenChanged(id, cal);
        }
    }

    public void setJobTimeSent(long id, GregorianCalendar cal) {
        ((Job)this.get(id)).setTimeSent(cal);
        if (this.listener != null) {
            this.listener.timeSentHasBeenChanged(id, cal);
        }
        this.listener.statusHasBeenChanged(id, this.getJobStatus(id));
    }

    public void setJobTimeStarted(long id, GregorianCalendar cal) {
        ((Job)this.get(id)).setTimeStarted(cal);
        if (this.listener != null) {
            this.listener.timeStartedHasBeenChanged(id, cal);
            this.listener.statusHasBeenChanged(id, this.getJobStatus(id));
        }
    }

    public void setJobTimeDone(long id, GregorianCalendar cal) {
        ((Job)this.get(id)).setTimeDone(cal);
        if (this.listener != null) {
            this.listener.timeDoneHasBeenChanged(id, cal);
            this.listener.statusHasBeenChanged(id, this.getJobStatus(id));
        }
    }

    public void setTimedOut(long id, boolean timedOut) {
        ((Job)this.get(id)).setTimedOut(timedOut);
        if (this.listener != null) {
            this.listener.timedOutStatusChanged(id, timedOut);
            this.listener.statusHasBeenChanged(id, "Timed-out");
        }
    }

    public void addJobsTableListener(JobsTableListener listener) {
        this.listener = listener;
    }

    public double getResponseTimeInSeconds() {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && !((Job)this.get(i)).isTimedOut() && (time = ((Job)this.get(i)).getTimeBetweenSubmissionTimeAndDoneTimeInSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public double getResponseTimeInSecondsIncludingTimedOut() {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && (time = ((Job)this.get(i)).getTimeBetweenSubmissionTimeAndDoneTimeInSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public double getSchedulingDelayInMilliSeconds() {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && !((Job)this.get(i)).isTimedOut() && (time = ((Job)this.get(i)).getTimeBetweenSubmissionTimeAndSentTimeInMilliSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE * 1000)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public double getSchedulingDelayInMilliSecondsIncludingTimedOut() {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && (time = ((Job)this.get(i)).getTimeBetweenSubmissionTimeAndSentTimeInMilliSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE * 1000)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public double getCommunicationDelayInSeconds() {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && !((Job)this.get(i)).isTimedOut() && (time = ((Job)this.get(i)).getTimeBetweenStartTimeAndSentTimeInSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public double getCommunicationDelayInSecondsIncludingTimedOut() {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && (time = ((Job)this.get(i)).getTimeBetweenStartTimeAndSentTimeInSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public double getResponseTimeInSeconds(int jobClassID) {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && !((Job)this.get(i)).isTimedOut() && ((Job)this.get(i)).getJobClassID() == jobClassID && (time = ((Job)this.get(i)).getTimeBetweenSubmissionTimeAndDoneTimeInSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public double getResponseTimeInSecondsIncludingTimedOut(int jobClassID) {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && ((Job)this.get(i)).getJobClassID() == jobClassID && (time = ((Job)this.get(i)).getTimeBetweenSubmissionTimeAndDoneTimeInSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public double getSchedulingDelayInMilliSeconds(int jobClassID) {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && !((Job)this.get(i)).isTimedOut() && ((Job)this.get(i)).getJobClassID() == jobClassID && (time = ((Job)this.get(i)).getTimeBetweenSubmissionTimeAndSentTimeInMilliSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE * 1000)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public double getSchedulingDelayInMilliSecondsIncludingTimedOut(int jobClassID) {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && ((Job)this.get(i)).getJobClassID() == jobClassID && (time = ((Job)this.get(i)).getTimeBetweenSubmissionTimeAndSentTimeInMilliSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE * 1000)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public double getCommunicationDelayInSeconds(int jobClassID) {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && !((Job)this.get(i)).isTimedOut() && ((Job)this.get(i)).getJobClassID() == jobClassID && (time = ((Job)this.get(i)).getTimeBetweenStartTimeAndSentTimeInSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public double getCommunicationDelayInSecondsIncludingTimedOut(int jobClassID) {
        double sum = 0.0;
        double count = 0.0;
        long i = 1L;
        while (i <= (long)this.size()) {
            double time;
            if (this.get(i) != null && ((Job)this.get(i)).getJobClassID() == jobClassID && (time = ((Job)this.get(i)).getTimeBetweenStartTimeAndSentTimeInSeconds()) >= (double)(-1 * CLOCK_DIFFERENCE_TOLARNCE)) {
                if (time < 0.0) {
                    time = 0.0;
                }
                sum += time;
                count += 1.0;
            }
            ++i;
        }
        return sum / count;
    }

    public void saveToFile(String fileName) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        String hostname = "";
        String serverID = "";
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(fileName));
            writer.append("Job ID\tSecondary ID\tJob Class ID\tServer\tServer ID\tDate Submitted\tDate Sent\tDate Started\tDate Done\tJob Status\tT/O\n");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        long i = 0L;
        while (i < (long)this.size()) {
            GregorianCalendar dateSent = this.getJobTimeSent(i + 1L);
            String dateSentString = dateSent == null ? "" : formatter.format(dateSent.getTime());
            GregorianCalendar dateStarted = this.getJobTimeStarted(i + 1L);
            String dateStartedString = dateStarted == null ? "" : formatter.format(dateStarted.getTime());
            GregorianCalendar dateDone = this.getJobTimeDone(i + 1L);
            String dateDoneString = dateDone == null ? "" : formatter.format(dateDone.getTime());
            String timedOut = this.getJobIsTimedOut(i + 1L) ? "Yes" : "No";
            hostname = "";
            serverID = "";
            try {
                hostname = this.getJobServer(i + 1L).getHostName();
                serverID = String.valueOf(this.getJobServer(i + 1L).getIndex());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                writer.append(String.valueOf(this.getJobIndex(i + 1L)) + "\t" + this.getJobSecondaryID(i + 1L) + "\t" + this.getJobClassID(i + 1L) + "\t" + hostname + "\t" + serverID + "\t" + formatter.format(this.getJobTimeSubmitted(i + 1L).getTime()) + "\t" + dateSentString + "\t" + dateStartedString + "\t" + dateDoneString + "\t" + this.getJobStatus(i + 1L) + "\t" + timedOut + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int getTimeOutedJobsCount(int jobClassID) {
        int count = 0;
        long i = 1L;
        while (i <= (long)this.size()) {
            if (((Job)this.get(i)).getJobClassID() == jobClassID && ((Job)this.get(i)).isTimedOut()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int getTimeOutedJobsCount() {
        int count = 0;
        long i = 0L;
        while (i < (long)this.size()) {
            if (((Job)this.get(i)).isTimedOut()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static void main(String[] args) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        GregorianCalendar cal = new GregorianCalendar();
        System.out.print(formatter.format(cal.getTime()));
    }
}

