/*
 * Decompiled with CFR 0.152.
 */
package mapping.data;

import java.io.Serializable;
import java.util.Hashtable;
import mapping.data.Server;
import mapping.data.ServersTableListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServersTable
extends Hashtable<Integer, Server>
implements Serializable {
    private static final long serialVersionUID = 7932816264838278275L;
    private int serverIndex = 1;
    private transient ServersTableListener listener;

    public ServersTable() {
    }

    public ServersTable(int initialCapacity) {
        super(initialCapacity);
    }

    public ServersTable(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public void addServersListener(ServersTableListener listener) {
        this.listener = listener;
    }

    public void printAll() {
        System.out.print(this.toString());
    }

    public void addServer(Server server) {
        server.setIndex(this.serverIndex++);
        this.put(server.getIndex(), server);
    }

    public Server getServer(String hostname) {
        int i = 1;
        while (i <= this.size()) {
            if (((Server)this.get(i)).getHostName().equalsIgnoreCase(hostname.trim())) {
                return (Server)this.get(i);
            }
            ++i;
        }
        return null;
    }

    public void removeServer(int id) {
        this.remove(id);
        Server server = null;
        this.serverIndex = id;
        int i = id + 1;
        while (i <= this.size() + 1) {
            server = (Server)this.remove(i);
            this.addServer(server);
            ++i;
        }
    }

    public boolean isServerDown(int serverID) {
        return ((Server)this.get(serverID)).isDown();
    }

    public void setServerDown(int serverID, boolean down) {
        ((Server)this.get(serverID)).setDown(down);
        if (this.listener != null) {
            this.listener.upDownStatusChanged(serverID, down);
        }
    }

    public void clearServerActiveJobsNumber(int serverID) {
        ((Server)this.get(serverID)).clearActiveJobsNumber();
    }

    public double getFailurePeriodsMeanOfAllServersInMinutes() {
        double sum = 0.0;
        double count = 0.0;
        int i = 1;
        while (i <= this.size()) {
            if (this.get(i) != null && ((Server)this.get(i)).getFailureTrace() != null) {
                sum += ((Server)this.get(i)).getFailureTrace().getMeanOfPeriodsInMinutes();
                count += 1.0;
            }
            ++i;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return sum / count;
    }

    public double getUpTimeMeanOfAllServersInMinutes() {
        double sum = 0.0;
        double count = 0.0;
        int i = 1;
        while (i <= this.size()) {
            if (this.get(i) != null && ((Server)this.get(i)).getFailureTrace() != null) {
                sum += ((Server)this.get(i)).getFailureTrace().getMeanIfInterPeriodsInMinutes();
                count += 1.0;
            }
            ++i;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return sum / count;
    }
}

