/*
 * Decompiled with CFR 0.152.
 */
package pulling.availability_imposer;

import java.io.Serializable;
import java.util.Stack;
import pulling.availability_imposer.AvailabilityImposer;
import pulling.availability_imposer.Node;

public class Net
implements Serializable {
    private static final long serialVersionUID = -2613849368573511720L;
    private Node startNode;

    public Node getStartNode() {
        return this.startNode;
    }

    public void setStartNode(Node startNode) {
        this.startNode = startNode;
    }

    public void traverse() {
        Stack<Node> stack = new Stack<Node>();
        this.getStartNode().print();
        this.getStartNode().visited = true;
        stack.push(this.getStartNode());
        while (!stack.isEmpty()) {
            Node n1 = (Node)stack.pop();
            int i = 0;
            while (i < n1.getNeighboursNumber()) {
                Node n2 = n1.getNeighbour(i);
                if (!n2.visited) {
                    n2.visit();
                    stack.push(n2);
                }
                ++i;
            }
            System.out.print("-------------\n");
        }
    }

    public static void main(String[] args) {
        Node n1 = new Node(0.5, "N1", 1000L);
        Node n2 = new Node(0.5, "N2", 2000L);
        Node n3 = new Node(0.5, "N3", 3000L);
        Node n4 = new Node(0.5, "N4", 4000L);
        n1.addArch(0.3, n3);
        n1.addArch(0.7, n2);
        n2.addArch(0.4, n3);
        n2.addArch(0.6, n1);
        n3.addArch(0.4, n4);
        n3.addArch(0.3, n2);
        n3.addArch(0.3, n1);
        n4.addArch(0.5, n1);
        n4.addArch(0.5, n3);
        Net net = new Net();
        net.setStartNode(n1);
        net.traverse();
        Thread t = new Thread(new AvailabilityImposer(net));
        t.start();
    }
}

