/*
 * Decompiled with CFR 0.152.
 */
package pulling.availability_predection;

import java.util.GregorianCalendar;

public class TimeStamp {
    private int hour;
    private int minute;

    public TimeStamp() {
        this.setHour(0);
        this.setMinute(0);
    }

    public TimeStamp(int hour, int minute) {
        this.setHour(hour);
        this.setMinute(minute);
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour % 60;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute % 60;
    }

    public void addHours(int addedHours) {
        this.setHour((this.getHour() + addedHours) % 24);
    }

    public void addMinutes(int addedMinutes) {
        this.addHours((this.getMinute() + addedMinutes) / 60);
        this.setMinute((this.getMinute() + addedMinutes) % 60);
    }

    public String toString() {
        String hour = "" + this.getHour();
        String minute = "" + this.getMinute();
        if (this.getHour() < 10) {
            hour = "0" + hour;
        }
        if (this.getMinute() < 10) {
            minute = "0" + minute;
        }
        return String.valueOf(hour) + "_" + minute;
    }

    public int howManyPeriodsBefore(int period) {
        int sum = this.getHour() * 60 / period;
        return sum += this.getMinute() / period;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public static void main(String[] args) {
        TimeStamp t = new TimeStamp(0, 0);
        int i = 0;
        while (i < 1000) {
            t.print();
            t.addMinutes(7);
            ++i;
        }
    }

    public static TimeStamp getTimeStamp(GregorianCalendar cal) {
        if (cal.get(9) == 0) {
            return new TimeStamp(cal.get(10), cal.get(12));
        }
        return new TimeStamp(cal.get(10) + 12, cal.get(12));
    }
}

