/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.geo.proj;

import drasys.or.geom.GeomException;
import drasys.or.geom.geo.CoordinateSystem;
import drasys.or.geom.geo.EllipsoidI;
import drasys.or.geom.geo.Point;
import drasys.or.geom.geo.PointI;
import drasys.or.geom.geo.RangeI;
import drasys.or.geom.geo.proj.Conic;
import drasys.or.geom.geo.proj.ConicI;
import drasys.or.geom.geo.proj.ProjectionI;

public class Albers
extends Conic
implements ProjectionI,
ConicI {
    double _n;
    double _c;
    double _ec;
    double _dd;
    double _n2;

    public Albers(double d, double d2) throws GeomException {
        super(d, d2);
    }

    public Albers(RangeI rangeI) throws GeomException {
        super(rangeI);
    }

    public drasys.or.geom.rect2.PointI forward(PointI pointI) throws GeomException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.01745329251994 * pointI.latitude();
        double d4 = 0.01745329251994 * pointI.longitude();
        double d5 = this._c - this._n * this.qsfn(Math.sin(d3));
        if (d5 < 0.0) {
            throw new GeomException("Less than zero");
        }
        d5 = this._dd * Math.sqrt(d5);
        d = d5 * Math.sin(d4 *= this._n);
        d2 = d5 * Math.cos(d4);
        return new drasys.or.geom.rect2.Point(d * this._er + this._easting, d2 * this._er + this._northing);
    }

    public PointI inverse(drasys.or.geom.rect2.PointI pointI) throws GeomException {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = (pointI.x() - this._easting) / this._er;
        double d5 = Math.sqrt(d4 * d4 + (d = (pointI.y() - this._northing) / this._er) * d);
        if (d5 == 0.0) {
            d2 = 0.0;
            d3 = this._n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            if (this._n < 0.0) {
                d5 = -d5;
                d4 = -d4;
                d = -d;
            }
            d3 = d5 / this._dd;
            d3 = Math.abs(this._ec - Math.abs(d3 = (this._c - d3 * d3) / this._n)) > CoordinateSystem.getInstance().getAccuracy() ? this.phi1(d3) : (d3 > 0.0 ? 1.5707963267948966 : -1.5707963267948966);
            d2 = Math.atan2(d4, d) / this._n;
        }
        return new Point(d2 / 0.01745329251994, d3 / 0.01745329251994);
    }

    public void setEllipsoid(EllipsoidI ellipsoidI) {
        super.setEllipsoid(ellipsoidI);
        double d = this._n = Math.sin(this._south);
        double d2 = Math.cos(this._south);
        boolean bl = Math.abs(this._south - this._north) >= CoordinateSystem.getInstance().getAccuracy();
        double d3 = this.msfn(d, d2);
        double d4 = this.qsfn(d);
        if (bl) {
            d = Math.sin(this._north);
            d2 = Math.cos(this._north);
            double d5 = this.msfn(d, d2);
            double d6 = this.qsfn(d);
            this._n = (d3 * d3 - d5 * d5) / (d6 - d4);
        }
        this._ec = 1.0 - 0.5 * this._oneMinusE2 * Math.log((1.0 - this._e) / (1.0 + this._e)) / this._e;
        this._c = d3 * d3 + this._n * d4;
        this._dd = 1.0 / this._n;
    }
}

