/*
 * Decompiled with CFR 0.152.
 */
package generating;

import arrival_generator.ArrivalGenerator;
import arrival_generator.EXP_AND_UNI_AG;
import java.util.GregorianCalendar;
import logging.Logger;
import mapping.Mapper;
import mapping.data.Job;
import mapping.data.JobClass;

public class JobsGenerator
implements Runnable {
    private JobClass jobClass;
    private Mapper mapper;
    private boolean alive = true;
    private int jobsGenerated = 0;
    private long sumOfSleepTime = 0L;
    private long sumOfExecutionTime = 0L;
    private long[] JobInfo;
    private GregorianCalendar startTime;
    private ArrivalGenerator arrivalgenerator;
    private Logger logger;

    public JobsGenerator(JobClass jobClass, Mapper mapper) {
        this.setJobClass(jobClass);
        this.setMapper(mapper);
        this.setArrivalGenerator(new EXP_AND_UNI_AG(jobClass, mapper));
        this.setLogger(new Logger("generating"));
    }

    protected long[] getJobInfo() {
        return this.JobInfo;
    }

    protected void setNextJobInfo() {
        this.JobInfo = this.getArrivalGenerator().getNextJobInfo();
    }

    protected JobClass getJobClass() {
        return this.jobClass;
    }

    protected void setJobClass(JobClass jobClass) {
        this.jobClass = jobClass;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public ArrivalGenerator getArrivalGenerator() {
        return this.arrivalgenerator;
    }

    public void setArrivalGenerator(ArrivalGenerator arrivalGenerator) {
        this.arrivalgenerator = arrivalGenerator;
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    private int getJobsGenerated() {
        return this.jobsGenerated;
    }

    private long getSumOfSleepTime() {
        return this.sumOfSleepTime;
    }

    public synchronized double getActualRate() {
        double timeUnitsSinceStart = (double)(new GregorianCalendar().getTimeInMillis() - this.getStartTime().getTimeInMillis()) / (60000.0 * this.getMapper().getTimeUnitInMinutes());
        System.out.print("difference:" + ((double)this.jobsGenerated / timeUnitsSinceStart - (double)this.getJobsGenerated() / ((double)this.getSumOfSleepTime() / (60000.0 * this.getMapper().getTimeUnitInMinutes()))));
        return (double)this.jobsGenerated / timeUnitsSinceStart;
    }

    public synchronized double getActualAverage() {
        return (double)this.getSumOfSleepTime() / (60000.0 * this.getMapper().getTimeUnitInMinutes()) / (double)this.getJobsGenerated();
    }

    public double getAcutualIterationAverage() {
        return (double)this.getSumOfExecutionTime() / (double)this.getJobsGenerated();
    }

    public synchronized long getSumOfExecutionTime() {
        return this.sumOfExecutionTime;
    }

    public synchronized void setSumOfExecutionTime(long sumOfExecutionTime) {
        this.sumOfExecutionTime = sumOfExecutionTime;
    }

    private GregorianCalendar getStartTime() {
        return this.startTime;
    }

    private void setStartTime(GregorianCalendar startTime) {
        this.startTime = startTime;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public synchronized int getJobsGeneratedNumber() {
        return this.jobsGenerated;
    }

    private synchronized void recordGeneration(long sleepTime, long executionTime) {
        ++this.jobsGenerated;
        this.sumOfSleepTime += sleepTime;
        this.sumOfExecutionTime += executionTime;
    }

    private long getNextExecutionTime() {
        return this.getJobInfo()[2];
    }

    private long generateJob() {
        long executionTime = this.getNextExecutionTime();
        Job job = new Job((int)this.getJobInfo()[0], executionTime);
        this.getMapper().submitJob(job);
        this.getLogger().log("Task generated from class: " + (int)this.getJobInfo()[0] + "\texecutionTime: " + executionTime);
        return executionTime;
    }

    public void run() {
        this.setStartTime(new GregorianCalendar());
        while (this.isAlive()) {
            this.setNextJobInfo();
            try {
                long sleepTime = this.getJobInfo()[1];
                Thread.sleep(sleepTime);
                if (!this.isAlive()) {
                    this.getArrivalGenerator().closeLogger();
                    return;
                }
                long executionTime = this.generateJob();
                this.recordGeneration(sleepTime, executionTime);
            }
            catch (InterruptedException e) {
                if (!this.isAlive()) {
                    this.getArrivalGenerator().closeLogger();
                    return;
                }
                e.printStackTrace();
            }
        }
    }
}

