/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import interfacing.MainFrame;
import interfacing.OurDefaultTableModel;
import interfacing.ProcessingRatesTableModel;
import interfacing.ServersProcessingRatesTableModelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import mapping.Mapper;

public class ServersProcessingRatesJPanel
extends JPanel {
    private static final long serialVersionUID = -1314942526341209428L;
    private String[] columnNames = new String[]{"Job Class ID", "Real Rate", "Assumed Rate"};
    private MainFrame frame;
    private int serverID;
    private JTable jTable;
    private ProcessingRatesTableModel tableModel;
    private ServersProcessingRatesTableModelListener serversProcessingRatesTableModelListener;
    private JScrollPane jTableScrollPane;

    public Mapper getMapper() {
        return this.frame.getMapper();
    }

    public int getServerID() {
        return this.serverID;
    }

    public void setServerId(int serverID) {
        this.serverID = serverID;
    }

    public ServersProcessingRatesJPanel() {
    }

    public ServersProcessingRatesJPanel(MainFrame frame, int id) {
        this.frame = frame;
        this.setServerId(id);
        this.jTable = new JTable();
        this.jTableScrollPane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.jTableScrollPane.setViewportView(this.jTable);
        this.add(this.jTableScrollPane);
        this.serversProcessingRatesTableModelListener = new ServersProcessingRatesTableModelListener(this.getMapper(), id);
        this.jTable.setGridColor(Color.BLACK);
        this.fillJTable();
        int h = (1 + this.jTable.getModel().getRowCount()) * this.jTable.getRowHeight();
        this.jTable.setPreferredSize(new Dimension(200, h));
        this.jTableScrollPane.setPreferredSize(new Dimension(200, h));
        this.setPreferredSize(new Dimension(200, h));
    }

    public void fillJTable() {
        this.tableModel = new ProcessingRatesTableModel(this.columnNames, 0);
        this.jTable.setModel(this.tableModel);
        String realRateString = null;
        String assumedRateString = null;
        int i = 0;
        while (i < this.getMapper().getClassesTable().size()) {
            try {
                realRateString = String.valueOf(this.getMapper().getRealRate(this.getServerID(), i + 1));
                assumedRateString = String.valueOf(this.getMapper().getAssumedRate(this.getServerID(), i + 1));
            }
            catch (NullPointerException ex) {
                realRateString = "NaN";
                assumedRateString = "NaN";
            }
            Object[] s = new String[]{String.valueOf(i + 1), realRateString, assumedRateString};
            this.tableModel.addRow(s);
            ++i;
        }
        this.tableModel.addTableModelListener(this.serversProcessingRatesTableModelListener);
    }

    public void disableInput() {
        this.tableModel.setEditable(false);
    }

    public void enableInput() {
        this.tableModel.setEditable(true);
    }

    public void printModel(OurDefaultTableModel model) {
        int i = 0;
        while (i < model.getRowCount()) {
            int j = 0;
            while (j < model.getColumnCount()) {
                System.out.print(model.getValueAt(i, j) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }
}

