/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import adjusting.Adjuster;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import logging.Event;
import logging.Logger;
import mapping.Mapper;

public class CompletionServer
implements Runnable {
    private boolean alive = true;
    private int completionServerPort = 37931;
    private Mapper mapper;
    private Thread thisThread;
    private static final int NOTICALBE_DIFFERENCE_IN_TIME = 3000;
    private Logger completionEventsLogger;
    private Logger failuresLogger;
    ServerSocket serverSocket = null;
    Socket socket = null;
    DataInputStream in = null;

    public CompletionServer(Mapper mapper) {
        this.mapper = mapper;
        this.setCompletionEventsLogger(new Logger("completionServer"));
        this.setFailuresLogger(new Logger("failureServer"));
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public synchronized int getCompletionServerPort() {
        return this.completionServerPort;
    }

    public void setCompletionServerPort(int completionServerPort) {
        this.completionServerPort = completionServerPort;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public Logger getCompletionEventsLogger() {
        return this.completionEventsLogger;
    }

    public void setCompletionEventsLogger(Logger completionEventsLogger) {
        this.completionEventsLogger = completionEventsLogger;
    }

    public Logger getFailuresLogger() {
        return this.failuresLogger;
    }

    public void setFailuresLogger(Logger failuresLogger) {
        this.failuresLogger = failuresLogger;
    }

    public void startServer() {
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopServer() {
        boolean wasAlive = this.isAlive();
        this.setAlive(false);
        if (wasAlive) {
            this.thisThread.interrupt();
            this.thisThread = null;
        }
    }

    private GregorianCalendar convertToCal(String dateString) {
        Date date = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            date = formatter.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal;
    }

    private GregorianCalendar convertToCalAndAdd(String dateString, long millis) {
        Date date = null;
        try {
            SimpleDateFormat formatter = null;
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            date = formatter.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(14, (int)millis);
        return cal;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.setAlive(true);
        serverID = 0;
        serverAddress = new String();
        jobID = 0L;
        jobSecondaryID = 0L;
        dateStarted = new String();
        dateDone = new String();
        timeStamp = new String();
        differenceInTime = 0L;
        try {
            this.serverSocket = new ServerSocket(this.getCompletionServerPort());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        while (this.isAlive()) {
            block43: {
                block44: {
                    serverID = 0;
                    serverAddress = "";
                    jobID = 0L;
                    jobSecondaryID = 0L;
                    dateStarted = "";
                    dateDone = "";
                    timeStamp = "";
                    this.socket = this.serverSocket.accept();
                    if (this.isAlive()) break block43;
                    if (this.in == null) break block44;
                    try {
                        this.in.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
            try {
                try {
                    this.in = new DataInputStream(this.socket.getInputStream());
                    current = new GregorianCalendar();
                    while ((r = this.in.read()) != -1 && r != 35) {
                        timeStamp = String.valueOf(timeStamp) + (char)r;
                    }
                    timeStampCal = this.convertToCal(timeStamp);
                    differenceInTime = current.getTimeInMillis() - timeStampCal.getTimeInMillis();
                    if (Math.abs(differenceInTime) > 3000L) {
                        this.getCompletionEventsLogger().log(String.valueOf(serverAddress) + " has a difference of " + differenceInTime / 1000L + " sconds.");
                    }
                    while ((r = this.in.read()) != -1 && r != 35) {
                        if ((char)r - 48 < 0) continue;
                        serverID = 10 * serverID + ((char)r - 48);
                    }
                    while ((r = this.in.read()) != -1 && r != 35) {
                        serverAddress = String.valueOf(serverAddress) + (char)r;
                    }
                    while ((r = this.in.read()) != -1 && r != 35) {
                        jobID = 10L * jobID + (long)((char)r - 48);
                    }
                    while ((r = this.in.read()) != -1 && r != 35) {
                        jobSecondaryID = 10L * jobSecondaryID + (long)((char)r - 48);
                    }
                    while ((r = this.in.read()) != -1 && r != 35) {
                        dateStarted = String.valueOf(dateStarted) + (char)r;
                    }
                    while ((r = this.in.read()) != -1 && r != 35) {
                        dateDone = String.valueOf(dateDone) + (char)r;
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    if (this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (this.socket == null) ** GOTO lbl114
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable var15_24) {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw var15_24;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
lbl114:
            // 7 sources

            if (this.getMapper().isArtificialFailuresActive()) {
                if (!this.getMapper().getJobsTable().getJobHostName(jobID).equalsIgnoreCase(serverAddress)) {
                    System.out.println("CompletionServer Job Hostname: " + this.getMapper().getJobsTable().getJobHostName(jobID));
                    System.out.println(serverAddress);
                    continue;
                }
                if (Adjuster.didAFailureHappen(this.convertToCal(dateStarted), this.convertToCal(dateDone), this.getMapper().getServer(serverID))) {
                    this.getFailuresLogger().log("Server " + serverAddress + " failed between \t " + dateStarted + "\t" + dateDone);
                    System.err.println("CompletionServer.run(): A failure happen in server: " + serverAddress);
                    continue;
                }
            }
            try {
                this.getMapper().jobIsDone(serverID, jobID, this.convertToCalAndAdd(dateStarted, differenceInTime), this.convertToCalAndAdd(dateDone, differenceInTime));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.getCompletionEventsLogger().logEvent(new Event("Job is done.", jobID));
        }
    }
}

