/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import adjusting.Adjuster;
import adjusting.availability_adjusting.FailureTrace;
import executing.MapperSideExecuter;
import executing.MapperSideExecuter_BuiltIn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import logging.Logger;
import mapping.EndOfFailureAnnouncer;
import mapping.MappingScheme;
import mapping.TimeOutAnnouncer;
import mapping.data.IDsQueue;
import mapping.data.Job;
import mapping.data.JobClass;
import mapping.data.JobClassesTable;
import mapping.data.JobsTable;
import mapping.data.Server;
import mapping.data.ServersTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapper
implements Serializable {
    private static final long serialVersionUID = 6092448329256274523L;
    public static final long JOB_FAILED = -1L;
    public static final long JOB_FAILED_DUE_ACTUAL_ERROR = -2L;
    public static final long JOB_SECONDARY_ID_NOT_KNOWN = -3L;
    private ServersTable serversTable;
    private JobClassesTable classesTable;
    private JobsTable jobsTable;
    private MappingScheme mappingScheme;
    private MapperSideExecuter executer;
    private double timeUnitInMinutes = 3.0;
    private final int DEFAULT_JOBS_NUMBER = 3000;
    private transient Logger errorsLogger;
    private transient Logger failuresLogger;
    private transient EndOfFailureAnnouncer endOfFailureAnnouncer;
    private boolean artificialFailuresActive = true;
    private transient TimeOutAnnouncer timeOutAnnouncer;
    private boolean timeOutActive = true;
    private double timeOutFactor = 2.0;
    private int timeResolution = 10;
    private IDsQueue<Integer> availableServersQueue;
    private double failurePeriodsMean = 1.0;
    private double upTimePeriodsMean = 5.0;
    private GregorianCalendar startTime;
    private GregorianCalendar stopTime;
    private boolean cancelFlag = false;
    private int[] serverIDs;
    private long jobID;

    public Mapper() {
        this.setJobsTable(new JobsTable(3000));
        this.setExecuter(new MapperSideExecuter_BuiltIn());
        this.setErrorsLogger(new Logger("errors"));
        this.setFailuresLogger(new Logger("artificialFailures"));
        this.setTimeOutAnnouncer(new TimeOutAnnouncer(this));
        this.getTimeOutAnnouncer().startThread();
        this.setEndOfFailureAnnouncer(new EndOfFailureAnnouncer(this));
        this.getEndOfFailureAnnouncer().startThread();
    }

    public String getMapperHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getcancelFlag() {
        return this.cancelFlag;
    }

    public int[] getserverIDs() {
        return this.serverIDs;
    }

    public long getjobID() {
        return this.jobID;
    }

    public void setcancelFlag(boolean CancelFlag, int[] serverids, long jobid) {
        this.cancelFlag = CancelFlag;
        serverids = this.serverIDs;
        jobid = this.jobID;
    }

    public void resetcancelFlag() {
        this.cancelFlag = false;
    }

    public MapperSideExecuter getExecuter() {
        return this.executer;
    }

    public void setExecuter(MapperSideExecuter executer) {
        this.executer = executer;
    }

    public ServersTable getServersTable() {
        return this.serversTable;
    }

    public void setServersTable(ServersTable serverstable) {
        this.serversTable = serverstable;
    }

    public JobClassesTable getClassesTable() {
        return this.classesTable;
    }

    public void setClassesTable(JobClassesTable classesTable) {
        this.classesTable = classesTable;
    }

    public JobsTable getJobsTable() {
        return this.jobsTable;
    }

    public void setJobsTable(JobsTable jobsTable) {
        this.jobsTable = jobsTable;
    }

    public MappingScheme getMappingScheme() {
        return this.mappingScheme;
    }

    public void setMappingScheme(MappingScheme mappingScheme) {
        this.mappingScheme = mappingScheme;
    }

    public double getTimeUnitInMinutes() {
        return this.timeUnitInMinutes;
    }

    public void setTimeUnitInMinutes(double timeUnitInMinutes) {
        this.timeUnitInMinutes = timeUnitInMinutes;
        this.fillActualProcessingRates();
    }

    public Logger getErrorsLogger() {
        return this.errorsLogger;
    }

    public void setErrorsLogger(Logger errorsLogger) {
        this.errorsLogger = errorsLogger;
    }

    public Logger getFailuresLogger() {
        return this.failuresLogger;
    }

    public void setFailuresLogger(Logger failuresLogger) {
        this.failuresLogger = failuresLogger;
    }

    public EndOfFailureAnnouncer getEndOfFailureAnnouncer() {
        return this.endOfFailureAnnouncer;
    }

    public void setEndOfFailureAnnouncer(EndOfFailureAnnouncer endOfFailureAnnouncer) {
        this.endOfFailureAnnouncer = endOfFailureAnnouncer;
    }

    public boolean isArtificialFailuresActive() {
        return this.artificialFailuresActive;
    }

    public void setArtificialFailuresActive(boolean artificialFailuresActive) {
        this.artificialFailuresActive = artificialFailuresActive;
    }

    public TimeOutAnnouncer getTimeOutAnnouncer() {
        return this.timeOutAnnouncer;
    }

    public void setTimeOutAnnouncer(TimeOutAnnouncer timeOutAnnouncer) {
        this.timeOutAnnouncer = timeOutAnnouncer;
    }

    public boolean isTimeOutActive() {
        return this.timeOutActive;
    }

    public void setTimeOutActive(boolean timeOutActive) {
        this.timeOutActive = timeOutActive;
    }

    public double getTimeOutFactor() {
        return this.timeOutFactor;
    }

    public void setTimeOutFactor(double timeOutFactor) {
        this.timeOutFactor = timeOutFactor;
    }

    public int getTimeResolution() {
        return this.timeResolution;
    }

    public void setTimeResolution(int timeResolution) {
        this.timeResolution = timeResolution;
    }

    public IDsQueue<Integer> getAvailableServersQueue() {
        return this.availableServersQueue;
    }

    public void setAvailableServersQueue(IDsQueue<Integer> availableServersQueue) {
        this.availableServersQueue = availableServersQueue;
    }

    public double getFailurePeriodsMean() {
        return this.failurePeriodsMean;
    }

    public void setFailurePeriodsMean(double failurePeriodsMean) {
        this.failurePeriodsMean = failurePeriodsMean;
    }

    public double getUpTimePeriodsMean() {
        return this.upTimePeriodsMean;
    }

    public void setUpTimePeriodsMean(double upTimePeriodsMean) {
        this.upTimePeriodsMean = upTimePeriodsMean;
    }

    public GregorianCalendar getStartTime() {
        return this.startTime;
    }

    private void setStartTime(GregorianCalendar startTime) {
        this.startTime = startTime;
    }

    public GregorianCalendar getStopTime() {
        return this.stopTime;
    }

    private void setStopTime(GregorianCalendar stopTime) {
        this.stopTime = stopTime;
    }

    public void printServers() {
        this.getServersTable().printAll();
    }

    public void printClasses() {
        this.getClassesTable().printAll();
    }

    public synchronized void submitJob(Job job) {
        this.getJobsTable().addJob(job);
        if (this.getMappingScheme() != null) {
            this.getMappingScheme().mapJob(job);
        }
    }

    public synchronized void resubmitJob(Job job) {
        if (this.getMappingScheme() != null) {
            this.getMappingScheme().mapJob(job);
        }
    }

    protected long sendJob(long jobID_Received, int serverID) {
        Job job = (Job)this.getJobsTable().get(jobID_Received);
        if (job == null) {
            System.err.print("Job == NULL");
            return -3L;
        }
        int jobClassID = this.getJobsTable().getJobClassID(job.getIndex());
        JobClass jobClass = (JobClass)this.getClassesTable().get(jobClassID);
        Server server = (Server)this.getServersTable().get(serverID);
        double ratio = Adjuster.getRatio(jobClass, server);
        long jobSecondaryId = -4000L;
        GregorianCalendar currentTime = new GregorianCalendar();
        if (this.isArtificialFailuresActive() && Adjuster.isServerSufferingFromAFailure(currentTime, server)) {
            this.getFailuresLogger().log("Server " + server.getHostName() + " had an artifical failure.\t Job " + job.getIndex() + "could not be sent. ");
            GregorianCalendar endOfFailure = Adjuster.getEndOFFailurePeriod(currentTime, server);
            long differenceInMilliSeconds = endOfFailure.getTimeInMillis() - currentTime.getTimeInMillis();
            this.getEndOfFailureAnnouncer().add((double)differenceInMilliSeconds / 1000.0 / 60.0, (Server)this.getServersTable().get(serverID));
            System.err.println("Mapper.send Job: " + ((Server)this.getServersTable().get(serverID)).getHostName() + " is declared DOWN!!!");
            this.getServersTable().setServerDown(serverID, true);
            this.getMappingScheme().serverIsDown(serverID);
            this.getAvailableServersQueue().remove(serverID);
            return -2L;
        }
        jobSecondaryId = this.getExecuter().submitLoopJob(server.getHostName(), server.getIndex(), job.getIndex(), job.getexecutionTime(), ratio);
        this.getJobsTable().setJobSecondaryID(job.getIndex(), jobSecondaryId);
        if (jobSecondaryId != -1L && jobSecondaryId != -2L) {
            this.getJobsTable().setJobServer(job.getIndex(), server);
            this.getJobsTable().setJobTimeSent(job.getIndex(), new GregorianCalendar());
            server.incrementActiveJobsNumber();
            this.getAvailableServersQueue().remove(server.getIndex());
            if (this.isTimeOutActive()) {
                double timeExpectedInTU = 1.0 / server.getAssumedRate(jobClassID);
                if ((timeExpectedInTU /= server.getAvailability()) < 0.5) {
                    timeExpectedInTU = 0.5;
                }
                this.getTimeOutAnnouncer().add(timeExpectedInTU * this.getTimeOutFactor(), job.getIndex());
            }
        } else {
            this.getAvailableServersQueue().remove(server.getIndex());
            System.err.print(String.valueOf(server.getHostName()) + ": Communication error");
            this.getErrorsLogger().log("Mapper.sendJob(): Sending job failed.");
        }
        return jobSecondaryId;
    }

    public long cancelJob(long jobID_received, int serverID) {
        long returnval = -4000L;
        Job job = (Job)this.getJobsTable().get(jobID_received);
        if (job == null) {
            System.err.println("The job does not exist");
            return -3L;
        }
        Server server = this.getServer(serverID);
        returnval = this.getExecuter().deleteJob(job.getIndex(), server.getHostName());
        return returnval;
    }

    public String toString() {
        return String.valueOf(this.getClassesTable().toString()) + "\n" + this.getServersTable().toString() + "\n" + "Time out Factor: " + this.getTimeOutFactor() + "\nAF enabled: " + this.isArtificialFailuresActive() + "\nT/O enabled: " + this.isTimeOutActive();
    }

    public void print() {
        System.out.print(this.toString());
    }

    public void printAvailabilityQueue() {
        if (this.getAvailableServersQueue() != null) {
            this.getAvailableServersQueue().printServers();
        }
    }

    protected void jobIsDone(int serverID, long jobID, GregorianCalendar startTime, GregorianCalendar completionTime) {
        this.getAvailableServersQueue().enqueue(serverID);
        ((Server)this.getServersTable().get(serverID)).decrementActiveJobsNumber();
        this.getJobsTable().setJobTimeStarted(jobID, startTime);
        this.getJobsTable().setJobTimeDone(jobID, completionTime);
        if (this.cancelFlag) {
            int i = 0;
            while (i < this.getserverIDs().length) {
                if (this.getserverIDs()[i] != serverID) {
                    this.cancelJob(jobID, this.getserverIDs()[i]);
                }
                ++i;
            }
        }
    }

    protected void jobTimedOut(long jobID) {
        this.getJobsTable().setTimedOut(jobID, true);
        this.getMappingScheme().handleJobTimeOut(jobID);
    }

    public Server getServer(int i) {
        return (Server)this.getServersTable().get(i);
    }

    public double getAssumedRate(int serverID, int jobClassID) {
        return ((Server)this.getServersTable().get(serverID)).getProcessingRate(jobClassID).getAssumedRate();
    }

    public double getRealRate(int serverID, int jobClassID) {
        return ((Server)this.getServersTable().get(serverID)).getProcessingRate(jobClassID).getRealRate();
    }

    public void setAssumedRate(int serverID, int jobClassID, double rate) {
        ((Server)this.getServersTable().get(serverID)).getProcessingRate(jobClassID).setAssumedRate(rate);
    }

    public void setRealRate(int serverID, int jobClassID, double rate) {
        ((Server)this.getServersTable().get(serverID)).getProcessingRate(jobClassID).setRealRate(rate);
    }

    public JobClass getJobClass(int i) {
        return (JobClass)this.getClassesTable().get(i);
    }

    public void initProcessingRates() {
        int h = 0;
        while (h < this.getServersTable().size()) {
            int i = 0;
            while (i < this.getClassesTable().size()) {
                this.getServer(h + 1).addProcessingRate(0.0, 0.0, i + 1);
                ++i;
            }
            ++h;
        }
    }

    public void startMapper() {
        this.setAvailableServersQueue(new IDsQueue<Integer>(this));
        int i = 1;
        while (i <= this.getServersTable().size()) {
            this.getAvailableServersQueue().enqueue(this.getServer(i).getIndex());
            ++i;
        }
        this.setStartTime(new GregorianCalendar());
        this.getMappingScheme().startMappingScheme();
    }

    public void stopMapper() {
        this.setStopTime(new GregorianCalendar());
        this.getMappingScheme().stopMappingScheme();
    }

    public double getTimeElapsedInTimeUnits() {
        GregorianCalendar current = new GregorianCalendar();
        if (this.getStopTime() == null) {
            return (double)(current.getTimeInMillis() - this.getStartTime().getTimeInMillis()) / 1000.0 / 60.0 / this.getTimeUnitInMinutes();
        }
        return (double)(this.getStopTime().getTimeInMillis() - this.getStartTime().getTimeInMillis()) / 1000.0 / 60.0 / this.getTimeUnitInMinutes();
    }

    public void fillProcessingRates() {
        if (this.getServersTable() == null) {
            return;
        }
        if (this.getServersTable().isEmpty()) {
            return;
        }
        int h = 0;
        while (h < this.getServersTable().size()) {
            int i = 0;
            while (i < this.getClassesTable().size()) {
                this.getServer(h + 1).addProcessingRate(this.getTimeUnitInMinutes() * 60.0 * 1000.0 / (double)this.getJobClass(i + 1).getexecutionTime(), this.getTimeUnitInMinutes() * 60.0 * 1000.0 / (double)this.getJobClass(i + 1).getexecutionTime(), i + 1);
                ++i;
            }
            ++h;
        }
    }

    public void fillActualProcessingRates() {
        if (this.getServersTable() == null) {
            return;
        }
        if (this.getServersTable().isEmpty()) {
            return;
        }
        int h = 0;
        while (h < this.getServersTable().size()) {
            int i = 0;
            while (i < this.getClassesTable().size()) {
                this.setRealRate(h + 1, i + 1, this.getTimeUnitInMinutes() * 60.0 * 1000.0 / (double)this.getJobClass(i + 1).getexecutionTime());
                ++i;
            }
            ++h;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveMapperAsObjects(String fileName) {
        ObjectOutputStream output = null;
        try {
            try {
                output = new ObjectOutputStream(new FileOutputStream(new File(fileName), true));
                output.writeObject(this.getClassesTable());
                output.writeObject(this.getServersTable());
                output.writeDouble(this.getTimeUnitInMinutes());
                output.writeDouble(this.getFailurePeriodsMean());
                output.writeDouble(this.getUpTimePeriodsMean());
                output.writeInt(this.getTimeResolution());
                output.writeBoolean(this.isTimeOutActive());
                output.writeBoolean(this.isArtificialFailuresActive());
                output.writeDouble(this.getTimeOutFactor());
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (output == null) return;
                try {
                    output.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (output == null) return;
                try {
                    output.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readMapperAsObjects(String fileName) {
        ObjectInputStream input = null;
        try {
            try {
                input = new ObjectInputStream(new FileInputStream(new File(fileName)));
                this.setClassesTable((JobClassesTable)input.readObject());
                this.setServersTable((ServersTable)input.readObject());
                this.setTimeUnitInMinutes(input.readDouble());
                this.setFailurePeriodsMean(input.readDouble());
                this.setUpTimePeriodsMean(input.readDouble());
                this.setTimeResolution(input.readInt());
                this.setTimeOutActive(input.readBoolean());
                this.setArtificialFailuresActive(input.readBoolean());
                this.setTimeOutFactor(input.readDouble());
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (input == null) return;
                try {
                    input.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (input == null) return;
                try {
                    input.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                if (input == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    input.close();
                    return;
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void fillAllFailureTraces(double failurePeriodsMean, double upTimeMean) {
        this.setFailurePeriodsMean(failurePeriodsMean);
        this.setUpTimePeriodsMean(upTimeMean);
        int i = 1;
        while (i <= this.getServersTable().size()) {
            GregorianCalendar startTime = new GregorianCalendar();
            GregorianCalendar endTime = new GregorianCalendar();
            endTime.add(10, 48);
            this.getServer(i).setFailureTrace(new FailureTrace());
            this.getServer(i).getFailureTrace().fillTrace(startTime, endTime, failurePeriodsMean, upTimeMean, this.getTimeUnitInMinutes());
            ++i;
        }
    }

    public void fillAllFailureTraces() {
        int i = 1;
        while (i <= this.getServersTable().size()) {
            GregorianCalendar startTime = new GregorianCalendar();
            GregorianCalendar endTime = new GregorianCalendar();
            endTime.add(10, 7);
            this.getServer(i).toString();
            this.getServer(i).setFailureTrace(new FailureTrace());
            this.getServer(i).getFailureTrace().fillTrace(startTime, endTime, this.getFailurePeriodsMean(), this.getUpTimePeriodsMean(), this.getTimeUnitInMinutes());
            ++i;
        }
    }

    public double[][] constructMueMatrix() {
        double[][] mue = new double[this.getClassesTable().size()][this.getServersTable().size()];
        int i = 1;
        while (i <= this.getClassesTable().size()) {
            int j = 1;
            while (j <= this.getServersTable().size()) {
                mue[i - 1][j - 1] = this.getAssumedRate(j, i);
                ++j;
            }
            ++i;
        }
        return mue;
    }

    public double[][] constructActualMueMatrix() {
        double[][] timeInProcessing = new double[this.getClassesTable().size()][this.getServersTable().size()];
        double[][] jobsProcessed = new double[this.getClassesTable().size()][this.getServersTable().size()];
        long l = 1L;
        while (l <= (long)this.getJobsTable().size()) {
            if (this.getJobsTable().getJobStatus(l).equals("Done")) {
                double[] dArray = timeInProcessing[this.getJobsTable().getJobClassID(l) - 1];
                int n = this.getJobsTable().getJobServer(l).getIndex() - 1;
                dArray[n] = dArray[n] + (double)(this.getJobsTable().getJobTimeDone(l).getTimeInMillis() - this.getJobsTable().getJobTimeStarted(l).getTimeInMillis()) / 1000.0 / 60.0 / this.getTimeUnitInMinutes();
                double[] dArray2 = jobsProcessed[this.getJobsTable().getJobClassID(l) - 1];
                int n2 = this.getJobsTable().getJobServer(l).getIndex() - 1;
                dArray2[n2] = dArray2[n2] + 1.0;
            }
            ++l;
        }
        double[][] actualMue = new double[this.getClassesTable().size()][this.getServersTable().size()];
        int i = 1;
        while (i <= this.getClassesTable().size()) {
            int j = 1;
            while (j <= this.getServersTable().size()) {
                actualMue[i - 1][j - 1] = jobsProcessed[i - 1][j - 1] / timeInProcessing[i - 1][j - 1];
                ++j;
            }
            ++i;
        }
        return actualMue;
    }
}

