/*
 * Decompiled with CFR 0.152.
 */
package pulling.availability_imposer;

import pulling.availability_imposer.Net;
import pulling.availability_imposer.Node;

public class AvailabilityImposer
implements Runnable {
    private Net net;
    private volatile boolean alive = true;

    public AvailabilityImposer(Net net) {
        this.setNet(net);
    }

    public Net getNet() {
        return this.net;
    }

    public void setNet(Net net) {
        this.net = net;
    }

    protected boolean isAlive() {
        return this.alive;
    }

    protected void setAlive(boolean alive) {
        this.alive = alive;
    }

    public void run() {
        Node current = this.getNet().getStartNode();
        double aj = current.getAj();
        long sleepTime = current.getPeriodToStay();
        this.imposeAvalability(aj, sleepTime);
        while (this.isAlive()) {
            current = this.getNext(current);
            this.imposeAvalability(current.getAj(), current.getPeriodToStay());
        }
    }

    private Node getNext(Node sourceNode) {
        double random = Math.random();
        double previousPropabilities = 0.0;
        int i = 0;
        while (i < sourceNode.getNeighboursNumber()) {
            double propability = sourceNode.getPropability(i);
            if (random > previousPropabilities && random <= propability + previousPropabilities) {
                System.out.println("Random: " + random + " and next node is: " + sourceNode.getNeighbour(i).getDescription() + "\n");
                return sourceNode.getNeighbour(i);
            }
            previousPropabilities += propability;
            ++i;
        }
        return null;
    }

    private void imposeAvalability(double aj, long period) {
        System.out.println("Aj: " + aj + " period: " + period);
        try {
            Thread.sleep(period);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

