/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.linear.algebra;

import drasys.or.linear.algebra.AlgebraError;
import drasys.or.linear.algebra.AlgebraException;
import drasys.or.linear.algebra.SVDecompositionI;
import drasys.or.matrix.ContiguousVector;
import drasys.or.matrix.DenseMatrix;
import drasys.or.matrix.DenseVector;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.RowArrayMatrix;
import drasys.or.matrix.SparseMatrix;
import drasys.or.matrix.VectorI;
import java.io.Serializable;

public class QRIteration
implements SVDecompositionI,
Serializable {
    private double _fuzz;
    private double[] _w = null;
    private double[] _wf = null;
    private double[][] _u = null;
    private double[][] _v = null;
    private int _rows;
    private int _columns;

    public QRIteration() {
    }

    public QRIteration(MatrixI matrixI) throws AlgebraException {
        this.decompose(matrixI);
    }

    private void _makeWf() {
        this._wf = new double[this._w.length];
        double d = 0.0;
        int n = 0;
        while (n < this._w.length) {
            if (this._w[n] > d) {
                d = this._w[n];
            }
            ++n;
        }
        double d2 = d * this._fuzz;
        int n2 = 0;
        while (n2 < this._w.length) {
            this._wf[n2] = this._w[n2] < d2 ? 0.0 : 1.0 / this._w[n2];
            ++n2;
        }
    }

    public double computeConditionNumber() {
        double d;
        if (this._u == null) {
            throw new AlgebraError("No matrix has been decomposed");
        }
        int n = this._w.length;
        double d2 = d = Math.abs(this._w[0]);
        int n2 = 1;
        while (n2 < n) {
            double d3 = Math.abs(this._w[n2]);
            if (d3 < d) {
                d = d3;
            }
            if (d3 > d2) {
                d2 = d3;
            }
            ++n2;
        }
        return d == 0.0 ? Double.NaN : d2 / d;
    }

    public DenseMatrix computeInverse() throws AlgebraException {
        DenseMatrix denseMatrix = new DenseMatrix(this._w.length, this._w.length);
        this.computeInverse(denseMatrix);
        return denseMatrix;
    }

    public MatrixI computeInverse(MatrixI matrixI) throws AlgebraException {
        if (this._u == null) {
            throw new AlgebraError("No matrix has been decomposed.");
        }
        if (this._u.length != this._w.length) {
            throw new AlgebraException("The decomposed matrix was not square.");
        }
        if (this._wf == null) {
            this._makeWf();
        }
        int n = this._w.length;
        int n2 = 0;
        while (n2 < n) {
            double[] dArray = this._v[n2];
            int n3 = 0;
            while (n3 < n) {
                double d = 0.0;
                double[] dArray2 = this._u[n3];
                int n4 = 0;
                while (n4 < n) {
                    d += dArray[n4] * this._wf[n4] * dArray2[n4];
                    ++n4;
                }
                matrixI.setElementAt(n2, n3, d);
                ++n3;
            }
            ++n2;
        }
        return matrixI;
    }

    public void decompose(int n, int n2, double[][] dArray, double[] dArray2, double[][] dArray3, double d) throws AlgebraException {
        int n3;
        double d2;
        double d3;
        int n4;
        double[] dArray4;
        double d4;
        int n5 = this._rows = n;
        int n6 = this._columns = n2;
        this._u = dArray;
        this._w = dArray2;
        this._v = dArray3;
        this._wf = null;
        this._fuzz = d;
        int n7 = 0;
        int n8 = 0;
        double[] dArray5 = new double[n6];
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n9 = 0;
        while (n9 < n6) {
            n7 = n9 + 1;
            dArray5[n9] = d6 * d5;
            d6 = 0.0;
            d4 = 0.0;
            d5 = 0.0;
            if (n9 < n5) {
                dArray4 = this._u[n9];
                n4 = n9;
                while (n4 < n5) {
                    d6 += Math.abs(this._u[n4][n9]);
                    ++n4;
                }
                if (d6 != 0.0) {
                    n4 = n9;
                    while (n4 < n5) {
                        double[] dArray6 = this._u[n4];
                        int n10 = n9;
                        dArray6[n10] = dArray6[n10] / d6;
                        d4 += this._u[n4][n9] * this._u[n4][n9];
                        ++n4;
                    }
                    d3 = dArray4[n9];
                    d5 = d3 >= 0.0 ? -Math.sqrt(d4) : Math.sqrt(d4);
                    d2 = d3 * d5 - d4;
                    dArray4[n9] = d3 - d5;
                    n3 = n7;
                    while (n3 < n6) {
                        d4 = 0.0;
                        n4 = n9;
                        while (n4 < n5) {
                            d4 += this._u[n4][n9] * this._u[n4][n3];
                            ++n4;
                        }
                        d3 = d4 / d2;
                        n4 = n9;
                        while (n4 < n5) {
                            double[] dArray7 = this._u[n4];
                            int n11 = n3;
                            dArray7[n11] = dArray7[n11] + d3 * this._u[n4][n9];
                            ++n4;
                        }
                        ++n3;
                    }
                    n4 = n9;
                    while (n4 < n5) {
                        double[] dArray8 = this._u[n4];
                        int n12 = n9;
                        dArray8[n12] = dArray8[n12] * d6;
                        ++n4;
                    }
                }
            }
            this._w[n9] = d6 * d5;
            d6 = 0.0;
            d4 = 0.0;
            d5 = 0.0;
            if (n9 < n5 && n9 != n6 - 1) {
                dArray4 = this._u[n9];
                n4 = n7;
                while (n4 < n6) {
                    d6 += Math.abs(dArray4[n4]);
                    ++n4;
                }
                if (d6 != 0.0) {
                    n4 = n7;
                    while (n4 < n6) {
                        int n13 = n4++;
                        double d8 = dArray4[n13] / d6;
                        dArray4[n13] = d8;
                        double d9 = d8;
                        d4 += d9 * d9;
                    }
                    d3 = dArray4[n7];
                    d5 = d3 >= 0.0 ? -Math.sqrt(d4) : Math.sqrt(d4);
                    d2 = d3 * d5 - d4;
                    dArray4[n7] = d3 - d5;
                    n4 = n7;
                    while (n4 < n6) {
                        dArray5[n4] = dArray4[n4] / d2;
                        ++n4;
                    }
                    n3 = n7;
                    while (n3 < n5) {
                        d4 = 0.0;
                        n4 = n7;
                        while (n4 < n6) {
                            d4 += this._u[n3][n4] * dArray4[n4];
                            ++n4;
                        }
                        n4 = n7;
                        while (n4 < n6) {
                            double[] dArray9 = this._u[n3];
                            int n14 = n4;
                            dArray9[n14] = dArray9[n14] + d4 * dArray5[n4];
                            ++n4;
                        }
                        ++n3;
                    }
                    n4 = n7;
                    while (n4 < n6) {
                        int n15 = n4++;
                        dArray4[n15] = dArray4[n15] * d6;
                    }
                }
            }
            d7 = Math.max(d7, Math.abs(this._w[n9]) + Math.abs(dArray5[n9]));
            ++n9;
        }
        n9 = n6 - 1;
        while (n9 >= 0) {
            dArray4 = this._v[n9];
            if (n9 < n6) {
                if (d5 != 0.0) {
                    double[] dArray10 = this._u[n9];
                    n3 = n7;
                    while (n3 < n6) {
                        this._v[n3][n9] = dArray10[n3] / dArray10[n7] / d5;
                        ++n3;
                    }
                    n3 = n7;
                    while (n3 < n6) {
                        d4 = 0.0;
                        n4 = n7;
                        while (n4 < n6) {
                            d4 += dArray10[n4] * this._v[n4][n3];
                            ++n4;
                        }
                        n4 = n7;
                        while (n4 < n6) {
                            double[] dArray11 = this._v[n4];
                            int n16 = n3;
                            dArray11[n16] = dArray11[n16] + d4 * this._v[n4][n9];
                            ++n4;
                        }
                        ++n3;
                    }
                }
                n3 = n7;
                while (n3 < n6) {
                    this._v[n3][n9] = 0.0;
                    dArray4[n3] = 0.0;
                    ++n3;
                }
            }
            dArray4[n9] = 1.0;
            d5 = dArray5[n9];
            n7 = n9--;
        }
        n9 = Math.min(n5, n6) - 1;
        while (n9 >= 0) {
            dArray4 = this._u[n9];
            n7 = n9 + 1;
            d5 = this._w[n9];
            n3 = n7;
            while (n3 < n6) {
                dArray4[n3] = 0.0;
                ++n3;
            }
            if (d5 != 0.0) {
                d5 = 1.0 / d5;
                n3 = n7;
                while (n3 < n6) {
                    d4 = 0.0;
                    n4 = n7;
                    while (n4 < n5) {
                        d4 += this._u[n4][n9] * this._u[n4][n3];
                        ++n4;
                    }
                    d3 = d4 / dArray4[n9] * d5;
                    n4 = n9;
                    while (n4 < n5) {
                        double[] dArray12 = this._u[n4];
                        int n17 = n3;
                        dArray12[n17] = dArray12[n17] + d3 * this._u[n4][n9];
                        ++n4;
                    }
                    ++n3;
                }
                n3 = n9;
                while (n3 < n5) {
                    double[] dArray13 = this._u[n3];
                    int n18 = n9;
                    dArray13[n18] = dArray13[n18] * d5;
                    ++n3;
                }
            } else {
                n3 = n9;
                while (n3 < n5) {
                    this._u[n3][n9] = 0.0;
                    ++n3;
                }
            }
            int n19 = n9--;
            dArray4[n19] = dArray4[n19] + 1.0;
        }
        n4 = n6 - 1;
        while (n4 >= 0) {
            int n20 = 1;
            while (n20 <= 30) {
                double d10;
                double d11;
                double[] dArray14;
                double d12;
                boolean bl = true;
                n7 = n4;
                while (n7 >= 0) {
                    n8 = n7 - 1;
                    if (Math.abs(dArray5[n7]) + d7 == d7) {
                        bl = false;
                        break;
                    }
                    if (Math.abs(this._w[n8]) + d7 == d7) break;
                    --n7;
                }
                if (bl) {
                    d12 = 0.0;
                    d4 = 1.0;
                    n9 = n7;
                    while (n9 < n4) {
                        d3 = d4 * dArray5[n9];
                        dArray5[n9] = d12 * dArray5[n9];
                        if (Math.abs(d3) + d7 == d7) break;
                        d5 = this._w[n9];
                        this._w[n9] = d2 = this.f1(d3, d5);
                        d2 = 1.0 / d2;
                        d12 = d5 * d2;
                        d4 = -d3 * d2;
                        n3 = 0;
                        while (n3 < n5) {
                            dArray14 = this._u[n3];
                            d11 = dArray14[n8];
                            d10 = dArray14[n9];
                            dArray14[n8] = d11 * d12 + d10 * d4;
                            dArray14[n9] = d10 * d12 - d11 * d4;
                            ++n3;
                        }
                        ++n9;
                    }
                }
                d10 = this._w[n4];
                if (n7 == n4) {
                    if (!(d10 < 0.0)) break;
                    this._w[n4] = -d10;
                    n3 = 0;
                    while (n3 < n6) {
                        this._v[n3][n4] = -this._v[n3][n4];
                        ++n3;
                    }
                    break;
                }
                double d13 = this._w[n7];
                n8 = n4 - 1;
                d11 = this._w[n8];
                d5 = dArray5[n8];
                d2 = dArray5[n4];
                d3 = ((d11 - d10) * (d11 + d10) + (d5 - d2) * (d5 + d2)) / (2.0 * d2 * d11);
                d5 = this.f1(d3, 1.0);
                d3 = ((d13 - d10) * (d13 + d10) + d2 * (d11 / (d3 + (d3 >= 0.0 ? d5 : -d5)) - d2)) / d13;
                d4 = 1.0;
                d12 = 1.0;
                n3 = n7;
                while (n3 <= n8) {
                    n9 = n3 + 1;
                    d5 = dArray5[n9];
                    d11 = this._w[n9];
                    d2 = d4 * d5;
                    d5 = d12 * d5;
                    dArray5[n3] = d10 = this.f1(d3, d2);
                    d12 = d3 / d10;
                    d4 = d2 / d10;
                    d3 = d13 * d12 + d5 * d4;
                    d5 = d5 * d12 - d13 * d4;
                    d2 = d11 * d4;
                    d11 *= d12;
                    int n21 = 0;
                    while (n21 < n6) {
                        dArray14 = this._v[n21];
                        d13 = dArray14[n3];
                        d10 = dArray14[n9];
                        dArray14[n3] = d13 * d12 + d10 * d4;
                        dArray14[n9] = d10 * d12 - d13 * d4;
                        ++n21;
                    }
                    this._w[n3] = d10 = this.f1(d3, d2);
                    if (d10 != 0.0) {
                        d10 = 1.0 / d10;
                        d12 = d3 * d10;
                        d4 = d2 * d10;
                    }
                    d3 = d12 * d5 + d4 * d11;
                    d13 = d12 * d11 - d4 * d5;
                    n21 = 0;
                    while (n21 < n5) {
                        dArray14 = this._u[n21];
                        d11 = dArray14[n3];
                        d10 = dArray14[n9];
                        dArray14[n3] = d11 * d12 + d10 * d4;
                        dArray14[n9] = d10 * d12 - d11 * d4;
                        ++n21;
                    }
                    ++n3;
                }
                dArray5[n7] = 0.0;
                dArray5[n4] = d3;
                this._w[n4] = d13;
                ++n20;
            }
            --n4;
        }
    }

    public void decompose(MatrixI matrixI) throws AlgebraException {
        int n = matrixI.sizeOfRows();
        int n2 = matrixI.sizeOfColumns();
        double[] dArray = new double[n2];
        double[][] dArray2 = matrixI.getArray();
        double[][] dArray3 = new double[n2][n2];
        this.decompose(n, n2, dArray2, dArray, dArray3, matrixI.getEpsilon());
    }

    private double f1(double d, double d2) {
        double d3;
        double d4 = Math.abs(d);
        if (d4 > (d3 = Math.abs(d2))) {
            double d5 = d3 / d4;
            return d4 * Math.sqrt(1.0 + d5 * d5);
        }
        double d6 = d4 / d3;
        return d3 == 0.0 ? 0.0 : d3 * Math.sqrt(1.0 + d6 * d6);
    }

    public DenseMatrix getU() {
        return this._u == null ? null : new DenseMatrix(this._u);
    }

    public MatrixI getU(MatrixI matrixI) {
        if (this._u == null) {
            return null;
        }
        RowArrayMatrix rowArrayMatrix = new RowArrayMatrix(this._u, true);
        matrixI.setElements(rowArrayMatrix);
        return matrixI;
    }

    public DenseMatrix getV() {
        return this._v == null ? null : new DenseMatrix(this._v);
    }

    public MatrixI getV(MatrixI matrixI) {
        if (this._v == null) {
            return null;
        }
        RowArrayMatrix rowArrayMatrix = new RowArrayMatrix(this._v, true);
        matrixI.setElements(rowArrayMatrix);
        return matrixI;
    }

    public SparseMatrix getW() {
        return this._w == null ? null : new SparseMatrix(new DenseVector(this._w));
    }

    public MatrixI getW(MatrixI matrixI) {
        if (this._w == null) {
            return null;
        }
        ContiguousVector contiguousVector = new ContiguousVector(this._w, true);
        matrixI.setDiagonal(contiguousVector);
        return matrixI;
    }

    public boolean isIllConditioned() {
        if (this._u == null) {
            throw new AlgebraError("No matrix has been decomposed");
        }
        return 1.0 / this.computeConditionNumber() < 1.0E-12;
    }

    public boolean isSingular() {
        if (this._u == null) {
            throw new AlgebraError("No matrix has been decomposed");
        }
        int n = this._w.length;
        int n2 = 1;
        while (n2 < n) {
            if (this._w[n2] == 0.0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public DenseVector solveEquations(VectorI vectorI) throws AlgebraException {
        DenseVector denseVector = new DenseVector(this._w.length);
        this.solveEquations(vectorI, denseVector);
        return denseVector;
    }

    public VectorI solveEquations(VectorI vectorI, VectorI vectorI2) throws AlgebraException {
        double d;
        if (this._u == null) {
            throw new AlgebraError("No matrix has been decomposed");
        }
        int n = this._rows;
        int n2 = this._columns;
        double[] dArray = vectorI.getArray();
        if (this._wf == null) {
            this._makeWf();
        }
        double[] dArray2 = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            d = 0.0;
            if (this._wf[n3] != 0.0) {
                int n4 = 0;
                while (n4 < n) {
                    d += this._u[n4][n3] * dArray[n4];
                    ++n4;
                }
                d *= this._wf[n3];
            }
            dArray2[n3] = d;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            d = 0.0;
            double[] dArray3 = this._v[n3];
            int n5 = 0;
            while (n5 < n2) {
                d += dArray3[n5] * dArray2[n5];
                ++n5;
            }
            vectorI2.setElementAt(n3, d);
            ++n3;
        }
        return vectorI2;
    }
}

