/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix.complex;

import drasys.or.Complex;
import drasys.or.ComplexI;
import drasys.or.matrix.complex.ContiguousMatrix;
import drasys.or.matrix.complex.DenseVector;
import drasys.or.matrix.complex.MatrixElementI;
import drasys.or.matrix.complex.MatrixI;
import drasys.or.matrix.complex.RowMajorMatrix;
import drasys.or.matrix.complex.VectorElementI;
import drasys.or.matrix.complex.VectorI;
import drasys.or.util.Array;
import drasys.or.util.ComplexArray;
import java.util.Enumeration;

public class ColumnMajorMatrix
extends ContiguousMatrix {
    public ColumnMajorMatrix(int n, int n2) {
        super(n, n2, n, n2);
    }

    public ColumnMajorMatrix(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public ColumnMajorMatrix(MatrixI matrixI) {
        super(matrixI);
        if (matrixI instanceof ColumnMajorMatrix) {
            ColumnMajorMatrix columnMajorMatrix = (ColumnMajorMatrix)matrixI;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n < this._sizeOfColumns) {
                ComplexArray.copy(this._sizeOfRows, this._values, n2, 1, columnMajorMatrix._values, n3, 1);
                ++n;
                n2 += this._capacityOfRows;
                n3 += columnMajorMatrix._capacityOfRows;
            }
        } else if (matrixI instanceof RowMajorMatrix) {
            RowMajorMatrix rowMajorMatrix = (RowMajorMatrix)matrixI;
            int n = 0;
            int n4 = 0;
            int n5 = 0;
            while (n < this._sizeOfColumns) {
                ComplexArray.copy(this._sizeOfRows, this._values, n4, 1, rowMajorMatrix._values, n5, rowMajorMatrix._capacityOfRows);
                ++n;
                n4 += this._capacityOfRows;
                ++n5;
            }
        } else {
            Enumeration enumeration = matrixI.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                this.setElementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), matrixElementI.getValue());
            }
        }
    }

    public ColumnMajorMatrix(VectorI vectorI) {
        super(vectorI);
    }

    public ColumnMajorMatrix(double[][] dArray) {
        super(dArray);
        int n = 0;
        while (n < dArray.length) {
            double[] dArray2 = dArray[n];
            if (dArray2 != null) {
                ComplexArray.copy(dArray2.length / 2, this._values, n, this._capacityOfRows, dArray2, 0, 1);
            }
            ++n;
        }
    }

    public ColumnMajorMatrix(double[][] dArray, double[][] dArray2) {
        super(dArray, dArray2);
        int n = 2 * this._capacityOfRows;
        int n2 = 0;
        while (n2 < this._sizeOfRows) {
            double[] dArray3 = dArray == null ? null : dArray[n2];
            double[] dArray4 = dArray2 == null ? null : dArray2[n2];
            int n3 = 2 * n2;
            if (dArray3 != null) {
                Array.copy(dArray3.length, this._values, n3, n, dArray3, 0, 1);
            }
            if (dArray4 != null) {
                Array.copy(dArray4.length, this._values, n3 + 1, n, dArray4, 0, 1);
            }
            ++n2;
        }
    }

    public void addColumn(VectorI vectorI) {
        int n = this._sizeOfColumns;
        this.setSize(this._sizeOfRows, this._sizeOfColumns + 1);
        if (vectorI == null) {
            return;
        }
        if (vectorI instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vectorI;
            int n2 = Math.min(vectorI.size(), this._sizeOfRows);
            ComplexArray.copy(n2, this._values, n * this._capacityOfRows, 1, denseVector._values, 0, 1);
        } else {
            Enumeration enumeration = vectorI.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                int n3 = vectorElementI.getIndex();
                if (n3 >= this._sizeOfRows) continue;
                this.setElementAt(n3, n, vectorElementI.getValue());
            }
        }
    }

    public void addRow(VectorI vectorI) {
        int n = this._sizeOfRows;
        this.setSize(this._sizeOfRows + 1, this._sizeOfColumns);
        if (vectorI == null) {
            return;
        }
        if (vectorI instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vectorI;
            int n2 = Math.min(vectorI.size(), this._sizeOfColumns);
            ComplexArray.copy(n2, this._values, this._sizeOfRows - 1, this._capacityOfColumns, denseVector._values, 0, 1);
        } else {
            Enumeration enumeration = vectorI.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                int n3 = vectorElementI.getIndex();
                if (n3 >= this._sizeOfColumns) continue;
                this.setElementAt(n, n3, vectorElementI.getValue());
            }
        }
    }

    public Enumeration columnElements(int n) {
        if (n < 0 || n >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return new ColumnEnum(n);
    }

    public Complex elementAt(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = 2 * (n + this._capacityOfRows * n2);
        return new Complex(this._values[n3], this._values[n3 + 1]);
    }

    public Complex elementAt(int n, int n2, Complex complex) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = 2 * (n + this._capacityOfRows * n2);
        if (complex == null) {
            return new Complex(this._values[n3], this._values[n3 + 1]);
        }
        complex.real = this._values[n3];
        complex.imag = this._values[n3 + 1];
        return complex;
    }

    public Enumeration elements() {
        return new Enum();
    }

    public double[][] getArray() {
        double[][] dArray = new double[this._sizeOfRows][this._sizeOfColumns];
        int n = 0;
        while (n < dArray.length) {
            double[] dArray2 = dArray[n];
            if (dArray2 != null) {
                ComplexArray.copy(dArray2.length, dArray2, 0, 1, this._values, n, this._capacityOfRows);
            }
            ++n;
        }
        return dArray;
    }

    public int getColumnIncrement() {
        return this._capacityOfRows;
    }

    public int getOffset(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return n + this._capacityOfRows * n2;
    }

    public int getRowIncrement() {
        return 1;
    }

    public boolean isColumnMajor() {
        return true;
    }

    public boolean isRowMajor() {
        return false;
    }

    public Enumeration rowElements(int n) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        return new RowEnum(n);
    }

    public void setCapacity(int n, int n2) {
        if (n <= this._capacityOfRows && n2 <= this._capacityOfColumns) {
            return;
        }
        double[] dArray = new double[n * n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < this._sizeOfColumns) {
            ComplexArray.copy(this._sizeOfRows, dArray, n5, 1, this._values, n4, 1);
            ++n3;
            n4 += this._capacityOfRows;
            n5 += n;
        }
        this._values = dArray;
        this._capacityOfRows = n;
        this._capacityOfColumns = n2;
    }

    public void setElementAt(int n, int n2, ComplexI complexI) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = 2 * (n + this._capacityOfRows * n2);
        this._values[n3] = complexI.getReal();
        this._values[n3 + 1] = complexI.getImag();
    }

    public void setSize(int n, int n2) {
        Complex complex = new Complex();
        if (n > this._capacityOfRows || n2 > this._capacityOfColumns) {
            this.setCapacity(n, n2);
        }
        int n3 = this._sizeOfColumns;
        int n4 = this._sizeOfColumns * this._capacityOfRows;
        while (n3 < n2) {
            ComplexArray.copy(n, this._values, n4, 1, (ComplexI)complex);
            ++n3;
            n4 += this._capacityOfRows;
        }
        if (n > this._sizeOfRows) {
            int n5 = n - this._sizeOfRows;
            int n6 = 0;
            int n7 = this._sizeOfRows;
            while (n6 < this._sizeOfColumns) {
                ComplexArray.copy(n5, this._values, n7, 1, (ComplexI)complex);
                ++n6;
                n7 += this._capacityOfRows;
            }
        }
        this._sizeOfRows = n;
        this._sizeOfColumns = n2;
    }

    private class Enum
    implements Enumeration,
    MatrixElementI,
    ComplexI {
        int _row = 0;
        int _coef = 0;
        int _column = 0;
        int _mrow;
        int _mcol;
        double _mreal;
        double _mimag;

        Enum() {
        }

        public int getColumnIndex() {
            return this._mcol;
        }

        public double getImag() {
            return this._mimag;
        }

        public double getReal() {
            return this._mreal;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public ComplexI getValue() {
            return this;
        }

        public boolean hasMoreElements() {
            return this._column < ColumnMajorMatrix.this._sizeOfColumns;
        }

        public Object nextElement() {
            if (this._column >= ColumnMajorMatrix.this._sizeOfColumns) {
                return null;
            }
            this._mrow = this._row++;
            this._mcol = this._column++;
            this._mreal = ColumnMajorMatrix.this._values[this._coef++];
            this._mimag = ColumnMajorMatrix.this._values[this._coef++];
            if (this._row >= ColumnMajorMatrix.this._sizeOfRows) {
                this._coef = 2 * this._column * ColumnMajorMatrix.this._capacityOfRows;
                this._row = 0;
            }
            return this;
        }

        public void setValue(ComplexI complexI) {
            this._mreal = complexI.getReal();
            this._mimag = complexI.getImag();
            ColumnMajorMatrix.this.setElementAt(this._mrow, this._mcol, complexI);
        }
    }

    private class ColumnEnum
    implements Enumeration,
    MatrixElementI,
    ComplexI {
        int _row = 0;
        int _coef = 0;
        int _column = 0;
        int _mrow;
        double _mreal;
        double _mimag;

        public ColumnEnum(int n) {
            this._column = n;
            this._coef = this._column * ColumnMajorMatrix.this._capacityOfRows;
        }

        public int getColumnIndex() {
            return this._column;
        }

        public double getImag() {
            return this._mimag;
        }

        public double getReal() {
            return this._mreal;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public ComplexI getValue() {
            return this;
        }

        public boolean hasMoreElements() {
            return this._row < ColumnMajorMatrix.this._sizeOfRows;
        }

        public Object nextElement() {
            if (this._row >= ColumnMajorMatrix.this._sizeOfRows) {
                return null;
            }
            this._mrow = this._row++;
            this._mreal = ColumnMajorMatrix.this._values[this._coef++];
            this._mimag = ColumnMajorMatrix.this._values[this._coef++];
            return this;
        }

        public void setValue(ComplexI complexI) {
            this._mreal = complexI.getReal();
            this._mimag = complexI.getImag();
            ColumnMajorMatrix.this.setElementAt(this._mrow, this._column, complexI);
        }
    }

    class RowEnum
    implements Enumeration,
    MatrixElementI,
    ComplexI {
        int _row = 0;
        int _coef = 0;
        int _column = 0;
        int _mcolumn;
        double _mreal;
        double _mimag;

        public RowEnum(int n) {
            this._coef = this._row = n;
        }

        public int getColumnIndex() {
            return this._mcolumn;
        }

        public double getImag() {
            return this._mimag;
        }

        public double getReal() {
            return this._mreal;
        }

        public int getRowIndex() {
            return this._row;
        }

        public ComplexI getValue() {
            return this;
        }

        public boolean hasMoreElements() {
            return this._column < ColumnMajorMatrix.this._sizeOfColumns;
        }

        public Object nextElement() {
            if (this._column >= ColumnMajorMatrix.this._sizeOfColumns) {
                return null;
            }
            this._mcolumn = this._column++;
            this._mreal = ColumnMajorMatrix.this._values[this._coef];
            this._mimag = ColumnMajorMatrix.this._values[this._coef + 1];
            this._coef += 2 * ColumnMajorMatrix.this._capacityOfRows;
            return this;
        }

        public void setValue(ComplexI complexI) {
            this._mreal = complexI.getReal();
            this._mimag = complexI.getImag();
            ColumnMajorMatrix.this.setElementAt(this._row, this._column, complexI);
        }
    }
}

