/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix.complex;

import drasys.or.Complex;
import drasys.or.ComplexI;
import drasys.or.matrix.MatrixError;
import drasys.or.matrix.complex.ContiguousVectorI;
import drasys.or.matrix.complex.SizableVectorI;
import drasys.or.matrix.complex.Vect;
import drasys.or.matrix.complex.VectorElementI;
import drasys.or.matrix.complex.VectorI;
import drasys.or.util.Array;
import drasys.or.util.ComplexArray;
import java.util.Enumeration;

public class ContiguousVector
extends Vect
implements ContiguousVectorI,
SizableVectorI {
    int _size;
    double[] _values;

    public ContiguousVector() {
        this._size = 0;
        this._values = new double[20];
    }

    public ContiguousVector(int n) {
        this._size = n;
        this._values = new double[Math.max(20, 2 * this._size)];
    }

    public ContiguousVector(int n, int n2) {
        this._size = n;
        this._values = new double[Math.max(2 * n, 2 * n2)];
    }

    public ContiguousVector(int n, ComplexI complexI) {
        this._size = n;
        this._values = new double[Math.max(20, 2 * this._size)];
        ComplexArray.copy(this._size, this._values, 0, 1, complexI);
    }

    public ContiguousVector(VectorI vectorI) {
        this._size = vectorI.size();
        this._values = new double[2 * vectorI.size()];
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n = 2 * vectorElementI.getIndex();
            ComplexI complexI = vectorElementI.getValue();
            this._values[n] = complexI.getReal();
            this._values[n + 1] = complexI.getImag();
        }
    }

    public ContiguousVector(double[] dArray) {
        this(dArray, false);
    }

    public ContiguousVector(double[] dArray, boolean bl) {
        this._size = dArray.length / 2;
        if (bl) {
            this._values = dArray;
        } else {
            this._values = new double[dArray.length];
            ComplexArray.copy(this._size, this._values, 0, 1, dArray, 0, 1);
        }
    }

    public ContiguousVector(double[] dArray, double[] dArray2) {
        if (dArray == null && dArray2 == null) {
            throw new MatrixError("Both arrays can't be null.");
        }
        if (dArray != null && dArray2 != null && dArray.length != dArray2.length) {
            throw new MatrixError("The real and imag arrays must be the same length: " + dArray.length + ", " + dArray2.length);
        }
        this._size = dArray != null ? dArray.length : dArray2.length;
        this._values = new double[2 * this._size];
        if (dArray != null) {
            Array.copy(this._size, this._values, 0, 2, dArray, 0, 1);
        }
        if (dArray2 != null) {
            Array.copy(this._size, this._values, 1, 2, dArray2, 0, 1);
        }
    }

    public void addElement(ComplexI complexI) {
        if (this._size == this._values.length / 2) {
            this._values = ComplexArray.resize(2 * this._size, this._values);
        }
        int n = 2 * this._size++;
        this._values[n] = complexI.getReal();
        this._values[n + 1] = complexI.getImag();
    }

    public int capacity() {
        return this._values.length / 2;
    }

    public Complex elementAt(int n) {
        if (n >= this._size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new Complex(this._values[n *= 2], this._values[n + 1]);
    }

    public Complex elementAt(int n, Complex complex) {
        if (n >= this._size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n *= 2;
        if (complex == null) {
            return new Complex(this._values[n], this._values[n + 1]);
        }
        complex.real = this._values[n];
        complex.imag = this._values[n + 1];
        return complex;
    }

    public Enumeration elements() {
        return new Enum(this._values, this._size, 0, 1);
    }

    public double[] getArray() {
        double[] dArray = new double[2 * this._size];
        ComplexArray.copy(this._size, dArray, 0, 1, this._values, 0, 1);
        return dArray;
    }

    public int getBegin() {
        return 0;
    }

    public int getIncrement() {
        return 1;
    }

    public int getOffset(int n) {
        return n;
    }

    public double[] getValueArray() {
        return this._values;
    }

    public boolean isNull(int n) {
        return false;
    }

    public void setCapacity(int n) {
        if (n > this._values.length) {
            this._values = ComplexArray.resize(n, this._values);
        }
    }

    public void setElementAt(int n, ComplexI complexI) {
        if (n >= this._size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._values[n *= 2] = complexI.getReal();
        this._values[n + 1] = complexI.getImag();
    }

    public void setElements(ComplexI complexI) {
        ComplexArray.copy(this._values.length / 2, this._values, 0, 1, complexI);
    }

    public void setSize(int n) {
        if (n > this._values.length) {
            ComplexArray.resize(n, this._values);
        }
        this._size = n;
    }

    public int size() {
        return this._size;
    }

    public int sizeOfElements() {
        return this._size;
    }

    public ContiguousVectorI subvector(int n) {
        if (n >= this._size) {
            throw new MatrixError("Subvector 'begin' is past last element");
        }
        return new Sub(this._values, this._size - n, n, 1);
    }

    public ContiguousVectorI subvector(int n, int n2) {
        if (n > n2) {
            throw new MatrixError("Subvector 'begin' greater than 'end'");
        }
        if (n2 > this._size) {
            throw new MatrixError("Subvector 'end' is past last element");
        }
        return new Sub(this._values, n2 - n, n, 1);
    }

    public Complex sum(int n, int n2) {
        return ComplexArray.sum(n2 - n, this._values, n, 1, new Complex());
    }

    public Complex sumOfSquaredDifferences(int n, int n2, ComplexI complexI) {
        return ComplexArray.sumOfSquaredDifferences(n2 - n, this._values, n, 1, complexI, new Complex());
    }

    public Complex sumOfSquares(int n, int n2) {
        return ComplexArray.sumOfSquares(n2 - n, this._values, n, 1, new Complex());
    }

    static class Enum
    implements ComplexI,
    Enumeration,
    VectorElementI {
        int _siz;
        int _beg;
        int _inc;
        int _idx = 0;
        double[] _values;
        private int _mindex;
        private int _moff;
        private double _mreal;
        private double _mimag;

        Enum(double[] dArray, int n, int n2, int n3) {
            this._siz = n;
            this._beg = n2;
            this._inc = n3;
            this._values = dArray;
        }

        public double getImag() {
            return this._mimag;
        }

        public int getIndex() {
            return this._mindex;
        }

        public double getReal() {
            return this._mreal;
        }

        public ComplexI getValue() {
            return this;
        }

        public boolean hasMoreElements() {
            return this._idx < this._siz;
        }

        public Object nextElement() {
            if (this._idx >= this._siz) {
                return null;
            }
            this._mindex = this._idx++;
            this._moff = 2 * this._beg;
            this._mreal = this._values[this._moff];
            this._mimag = this._values[this._moff + 1];
            this._beg += this._inc;
            return this;
        }

        public void setValue(ComplexI complexI) {
            this._values[this._moff] = this._mreal = complexI.getReal();
            this._values[this._moff + 1] = this._mimag = complexI.getImag();
        }
    }

    static class Sub
    extends Vect
    implements ContiguousVectorI {
        int _siz;
        int _beg;
        int _inc;
        double[] _values;

        public Sub(double[] dArray, int n, int n2, int n3) {
            this._siz = n;
            this._beg = n2;
            this._inc = n3;
            this._values = dArray;
        }

        public Complex elementAt(int n) {
            if (n >= this._siz) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n2 = 2 * (this._beg + this._inc * n);
            return new Complex(this._values[n2], this._values[n2 + 1]);
        }

        public Complex elementAt(int n, Complex complex) {
            if (n >= this._siz) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n2 = 2 * (this._beg + this._inc * n);
            complex.real = this._values[n2];
            complex.imag = this._values[n2 + 1];
            return complex;
        }

        public Enumeration elements() {
            return new Enum(this._values, this._siz, this._beg, this._inc);
        }

        public double[] getArray() {
            double[] dArray = new double[this._siz];
            Array.copy(this._siz, dArray, 0, 1, this._values, this._beg, this._inc);
            return dArray;
        }

        public int getBegin() {
            return this._beg;
        }

        public int getIncrement() {
            return this._inc;
        }

        public int getOffset(int n) {
            return this._beg + this._inc * n;
        }

        public double[] getValueArray() {
            return this._values;
        }

        public boolean isNull(int n) {
            return false;
        }

        public void setElementAt(int n, ComplexI complexI) {
            if (n >= this._siz) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n2 = 2 * (this._beg + n * this._inc);
            this._values[n2] = complexI.getReal();
            this._values[n2 + 1] = complexI.getImag();
        }

        public void setElements(ComplexI complexI) {
            ComplexArray.copy(this._siz, this._values, this._beg, this._inc, complexI);
        }

        public int size() {
            return this._siz;
        }

        public int sizeOfElements() {
            return this._siz;
        }

        public ContiguousVectorI subvector(int n) {
            if (n >= this._siz) {
                throw new MatrixError("Subvector 'begin' is past last element");
            }
            return new Sub(this._values, this._siz - n, this._beg + this._inc * n, this._inc);
        }

        public ContiguousVectorI subvector(int n, int n2) {
            if (n > n2) {
                throw new MatrixError("Subvector 'begin' greater than 'end'");
            }
            if (n2 > this._siz) {
                throw new MatrixError("Subvector 'end' is past last element");
            }
            return new Sub(this._values, n2 - n, this._beg + this._inc * n, this._inc);
        }

        public Complex sum(int n, int n2) {
            if (n > n2) {
                throw new MatrixError("Subvector 'begin' greater than 'end'");
            }
            if (n2 > this._siz) {
                throw new MatrixError("Subvector 'end' is past last element");
            }
            return ComplexArray.sum(this._siz, this._values, this._beg, this._inc, new Complex());
        }

        public Complex sumOfSquaredDifferences(int n, int n2, ComplexI complexI) {
            if (n > n2) {
                throw new MatrixError("Subvector 'begin' greater than 'end'");
            }
            if (n2 > this._siz) {
                throw new MatrixError("Subvector 'end' is past last element");
            }
            return ComplexArray.sumOfSquaredDifferences(this._siz, this._values, this._beg, this._inc, complexI, new Complex());
        }

        public Complex sumOfSquares(int n, int n2) {
            if (n > n2) {
                throw new MatrixError("Subvector 'begin' greater than 'end'");
            }
            if (n2 > this._siz) {
                throw new MatrixError("Subvector 'end' is past last element");
            }
            return ComplexArray.sumOfSquares(this._siz, this._values, this._beg, this._inc, new Complex());
        }
    }
}

