/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.stat;

import drasys.or.matrix.VectorI;
import drasys.or.prob.BinomialDistribution;

public class PopulationProportion {
    int _n;
    int _cnt;
    double _p;
    double _pqn;

    public PopulationProportion(int n, int n2) {
        this._n = n;
        this._cnt = n2;
        this._p = (double)this._cnt / (double)this._n;
        this._pqn = Math.sqrt(this._p * (1.0 - this._p) / (double)this._n);
    }

    public PopulationProportion(VectorI vectorI) {
        this._n = vectorI.size();
        this._cnt = 0;
        int n = 0;
        while (n < this._n) {
            if (vectorI.elementAt(n) > 0.0) {
                ++this._cnt;
            }
            ++n;
        }
        this._p = (double)this._cnt / (double)this._n;
        this._pqn = Math.sqrt(this._p * (1.0 - this._p) / (double)this._n);
    }

    public PopulationProportion(VectorI vectorI, double d) {
        this._n = vectorI.size();
        this._cnt = 0;
        int n = 0;
        while (n < this._n) {
            if (vectorI.elementAt(n) >= d) {
                ++this._cnt;
            }
            ++n;
        }
        this._p = (double)this._cnt / (double)this._n;
        this._pqn = Math.sqrt(this._p * (1.0 - this._p) / (double)this._n);
    }

    public PopulationProportion(int[] nArray) {
        this._n = nArray.length;
        this._cnt = 0;
        int n = 0;
        while (n < this._n) {
            if (nArray[n] > 0) {
                ++this._cnt;
            }
            ++n;
        }
        this._p = (double)this._cnt / (double)this._n;
        this._pqn = Math.sqrt(this._p * (1.0 - this._p) / (double)this._n);
    }

    public PopulationProportion(int[] nArray, int n) {
        this._n = nArray.length;
        this._cnt = 0;
        int n2 = 0;
        while (n2 < this._n) {
            if (nArray[n2] >= n) {
                ++this._cnt;
            }
            ++n2;
        }
        this._p = (double)this._cnt / (double)this._n;
        this._pqn = Math.sqrt(this._p * (1.0 - this._p) / (double)this._n);
    }

    public PopulationProportion(boolean[] blArray) {
        this._n = blArray.length;
        this._cnt = 0;
        int n = 0;
        while (n < this._n) {
            if (blArray[n]) {
                ++this._cnt;
            }
            ++n;
        }
        this._p = (double)this._cnt / (double)this._n;
        this._pqn = Math.sqrt(this._p * (1.0 - this._p) / (double)this._n);
    }

    public double getLowerBound(double d) {
        if (this._cnt == 0) {
            return 0.0;
        }
        return BinomialDistribution.computeProportion(this._n, this._cnt - 1, 1.0 - 0.5 * (1.0 - d));
    }

    public double getProportion() {
        return this._p;
    }

    public double getUpperBound(double d) {
        if (this._cnt == this._n) {
            return 1.0;
        }
        return BinomialDistribution.computeProportion(this._n, this._cnt, 0.5 * (1.0 - d));
    }

    public double size() {
        return this._n;
    }
}

