/*
 * Decompiled with CFR 0.152.
 */
package interfacing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PropertiesJPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int properties;
    private JPanel mainPanel;
    private GridBagLayout gridBagLayout;
    private GridBagConstraints gbConstraints;
    private Component[] components;
    private JLabel[] labels;
    private String[] values;

    public PropertiesJPanel(int properties) {
        this.properties = properties;
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 17;
        this.gbConstraints.insets = new Insets(0, 0, 0, 10);
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.gridBagLayout = new GridBagLayout();
        this.mainPanel.setLayout(this.gridBagLayout);
        this.components = new Component[properties];
        this.labels = new JLabel[properties];
        this.values = new String[properties];
        int i = 0;
        while (i < properties) {
            this.components[i] = new JTextField(10);
            this.labels[i] = new JLabel("property " + i);
            this.gbConstraints.gridx = 0;
            this.gbConstraints.gridy = i;
            this.mainPanel.add((Component)this.labels[i], this.gbConstraints);
            this.gbConstraints.gridx = 1;
            this.mainPanel.add(this.components[i], this.gbConstraints);
            ++i;
        }
        this.gbConstraints.gridx = 0;
        this.gbConstraints.gridy = properties;
        this.gbConstraints.gridwidth = 2;
        this.gbConstraints.anchor = 10;
        this.gbConstraints.anchor = 17;
        this.mainPanel.setMaximumSize(new Dimension(700, 400));
        this.add((Component)this.mainPanel, "Center");
    }

    public PropertiesJPanel(String[] labelStrings, String[] tips) {
        this.properties = labelStrings.length;
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 11;
        this.gbConstraints.insets = new Insets(3, 3, 3, 10);
        this.setLayout(new FlowLayout());
        this.mainPanel = new JPanel();
        this.gridBagLayout = new GridBagLayout();
        this.mainPanel.setLayout(this.gridBagLayout);
        this.components = new Component[this.properties];
        this.labels = new JLabel[this.properties];
        this.values = new String[this.properties];
        int i = 0;
        while (i < this.properties) {
            this.components[i] = new JTextField(10);
            this.labels[i] = new JLabel(labelStrings[i]);
            if (tips != null) {
                this.labels[i].setToolTipText(tips[i]);
            }
            this.gbConstraints.gridx = 0;
            this.gbConstraints.gridy = i;
            this.mainPanel.add((Component)this.labels[i], this.gbConstraints);
            this.gbConstraints.gridx = 1;
            this.mainPanel.add(this.components[i], this.gbConstraints);
            ++i;
        }
        this.gbConstraints.gridx = 0;
        this.gbConstraints.gridy = this.properties;
        this.gbConstraints.gridwidth = 2;
        this.gbConstraints.anchor = 10;
        this.gbConstraints.anchor = 17;
        this.mainPanel.setMaximumSize(new Dimension(700, 400));
        this.add((Component)this.mainPanel, "Center");
        this.setAlignmentY(0.0f);
    }

    public void setLabelText(int i, String label) {
        this.labels[i].setText(label);
        this.repaint();
    }

    public void replaceValueComponent(int i, Component c) {
        this.mainPanel.remove(this.components[i]);
        this.gbConstraints.gridx = 1;
        this.gbConstraints.gridy = i;
        this.components[i] = c;
        this.mainPanel.add(this.components[i], this.gbConstraints);
        this.repaint();
    }

    public String getType(int i) {
        return this.components[i].getClass().toString();
    }

    public String getValue(int i) {
        if (this.components[i] instanceof JTextField) {
            return ((JTextField)this.components[i]).getText();
        }
        if (this.components[i] instanceof JCheckBox) {
            return String.valueOf(((JCheckBox)this.components[i]).isSelected());
        }
        if (this.components[i] instanceof JComboBox) {
            return ((JComboBox)this.components[i]).getSelectedItem().toString();
        }
        return "";
    }

    public void setValue(int i, String value) {
        if (this.components[i] instanceof JTextField) {
            ((JTextField)this.components[i]).setText(value);
            return;
        }
        if (this.components[i] instanceof JCheckBox) {
            if (value.equalsIgnoreCase("true")) {
                ((JCheckBox)this.components[i]).setSelected(true);
            } else {
                ((JCheckBox)this.components[i]).setSelected(false);
            }
            return;
        }
        if (this.components[i] instanceof JComboBox) {
            int j = 0;
            while (j < ((JComboBox)this.components[i]).getModel().getSize()) {
                if (((JComboBox)this.components[i]).getModel().getElementAt(j).toString().equalsIgnoreCase(value)) {
                    ((JComboBox)this.components[i]).setSelectedIndex(j);
                    return;
                }
                ++j;
            }
            ((JComboBox)this.components[i]).setSelectedIndex(0);
        }
    }

    public void clearField(int i) {
        if (this.components[i] instanceof JTextField) {
            ((JTextField)this.components[i]).setText("");
        }
        if (this.components[i] instanceof JCheckBox) {
            ((JCheckBox)this.components[i]).setSelected(false);
        }
        if (this.components[i] instanceof JComboBox) {
            ((JComboBox)this.components[i]).setSelectedIndex(0);
        }
    }

    public void clearFields() {
        int i = 0;
        while (i < this.properties) {
            this.clearField(i);
            ++i;
        }
    }

    public void printTypes() {
        int i = 0;
        while (i < this.properties) {
            System.out.println(this.components[i].getClass().toString());
            ++i;
        }
    }

    public void printComponents() {
        int i = 0;
        while (i < this.properties) {
            System.out.println(this.mainPanel.getComponent(i).toString());
            ++i;
        }
    }

    public void printValues() {
        int i = 0;
        while (i < this.properties) {
            System.out.println(this.values[i]);
            ++i;
        }
    }

    private void refreshValues() {
        int i = 0;
        while (i < this.properties) {
            this.values[i] = this.getValue(i);
            ++i;
        }
    }

    public String[] getValues() {
        this.refreshValues();
        return this.values;
    }
}

