/*
 * Decompiled with CFR 0.152.
 */
package logging;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.GregorianCalendar;

public class Event
implements Serializable {
    private static final long serialVersionUID = 998748623574865211L;
    private String description;
    private GregorianCalendar timestamp;
    private long id;
    private static final long NOT_DEFINED_YET = -5L;
    private static final DateFormat FORMATTER = DateFormat.getDateTimeInstance();

    public Event(String description, long id) {
        this.description = description;
        this.setTimestamp(new GregorianCalendar());
        this.setId(id);
    }

    public Event(String description, long jobId, GregorianCalendar timeStamp) {
        this.setDescription(description);
        this.setTimestamp(timeStamp);
        this.setId(jobId);
    }

    public Event(String description, GregorianCalendar timeStamp) {
        this.setTimestamp(timeStamp);
        this.setId(-5L);
        this.setDescription(description);
    }

    public Event(String description) {
        this.setTimestamp(new GregorianCalendar());
        this.setId(-5L);
        this.setDescription(description);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GregorianCalendar getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(GregorianCalendar timestamp) {
        this.timestamp = timestamp;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String toString() {
        if (this.getId() != -5L) {
            return "Job\t" + this.getId() + "\t" + this.getDescription() + "\t@\t" + FORMATTER.format(this.getTimestamp().getTime());
        }
        return String.valueOf(this.getDescription()) + " \t@\t" + FORMATTER.format(this.getTimestamp().getTime());
    }
}

