/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import mapping.LPAS_DG_MS;
import mapping.data.IDsQueue;
import mapping.data.Server;

public class LPAS_DG_MS_ThreadRB
implements Runnable {
    private boolean alive = true;
    private Thread thisThread;
    LPAS_DG_MS lpas_dg_ms;

    public LPAS_DG_MS_ThreadRB(LPAS_DG_MS lpas_dg_ms) {
        this.setAlive(true);
        this.setLpas_dg_ms(lpas_dg_ms);
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public LPAS_DG_MS getLpas_dg_ms() {
        return this.lpas_dg_ms;
    }

    public void setLpas_dg_ms(LPAS_DG_MS lpas_dg_ms) {
        this.lpas_dg_ms = lpas_dg_ms;
    }

    public void startThread() {
        System.out.println("LPAS Thread started");
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.thisThread.interrupt();
        this.thisThread = null;
    }

    public void run() {
        Server server = null;
        long sleepTime = 0L;
        IDsQueue<Integer> q = this.getLpas_dg_ms().getMapper().getAvailableServersQueue();
        while (this.isAlive()) {
            if (q.isEmpty()) continue;
            int serverID = q.peak();
            server = (Server)this.getLpas_dg_ms().getMapper().getServersTable().get(serverID);
            if (server.getNumberOfActiveJobs() != 0 || this.getLpas_dg_ms().getMapper().getServersTable().isServerDown(serverID)) continue;
            int result = this.getLpas_dg_ms().sendJobForServer(serverID);
            System.out.print("LPAS_THREAD: server " + serverID + " is sent.");
            switch (result) {
                case -5: {
                    sleepTime = 1000L;
                    System.out.println("Queues are empty.");
                    break;
                }
                case -4: {
                    System.out.println("No suitable job.");
                    q.advanceInRoundRobinFashion();
                    sleepTime = 10L;
                    break;
                }
                default: {
                    System.out.println("Success.");
                    sleepTime = 200L;
                }
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

