/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import java.util.Random;
import mapping.JobsQueue;
import mapping.Mapper;
import mapping.MappingScheme;
import mapping.SLQ_MS_Thread;
import mapping.data.Job;

public class SLQ_MS
extends MappingScheme {
    private static final long serialVersionUID = 637564873568473568L;
    private SLQ_MS_Thread slq_ms_thread;
    private JobsQueue[] classesQueues;
    static final int NO_JOBS = -1;

    public SLQ_MS(Mapper mapper) {
        super(mapper);
        this.initQueues();
        this.setDescription("SLQ");
    }

    protected SLQ_MS_Thread getSLQ_MS_Thread() {
        return this.slq_ms_thread;
    }

    protected void setSLQ_MS_Thread(SLQ_MS_Thread Slq_ms_thread) {
        this.slq_ms_thread = Slq_ms_thread;
    }

    public JobsQueue[] getClassesQueues() {
        return this.classesQueues;
    }

    public void setClassesQueue(JobsQueue[] ClassesQueues) {
        this.classesQueues = ClassesQueues;
    }

    public void startMappingScheme() {
        this.setSLQ_MS_Thread(new SLQ_MS_Thread(this));
        this.getSLQ_MS_Thread().startThread();
    }

    public void stopMappingScheme() {
        this.getSLQ_MS_Thread().stopThread();
    }

    protected void mapJob(Job job) {
        int jobClassID = this.getMapper().getJobsTable().getJobClassID(job.getIndex());
        this.getClassesQueues()[jobClassID - 1].enqueue(job);
    }

    public void handleJobTimeOut(long jobID) {
        this.getMapper().getJobsTable().setTimedOut(jobID, true);
        this.getMapper().getJobsTable().setJobServer(jobID, null);
        this.getMapper().resubmitJob((Job)this.getMapper().getJobsTable().get(jobID));
    }

    public void serverIsDown(int serverID) {
    }

    public void serverIsUp(int serverID) {
    }

    public void initQueues() {
        this.classesQueues = new JobsQueue[this.getMapper().getClassesTable().size()];
        int i = 0;
        while (i < this.getMapper().getClassesTable().size()) {
            this.classesQueues[i] = new JobsQueue();
            ++i;
        }
    }

    protected int sendJobForServer(int serverID) {
        int queueIndex = -1;
        int size = 0;
        Job job = null;
        int i = 0;
        while (i < this.getClassesQueues().length) {
            if (this.getClassesQueues()[i].size() > 0) {
                int tiebreak;
                if (this.getClassesQueues()[i].size() > size) {
                    size = this.getClassesQueues()[i].size();
                    queueIndex = i;
                } else if (this.getClassesQueues()[i].size() == size && (tiebreak = 1 + new Random().nextInt(2)) == 2) {
                    size = this.getClassesQueues()[i].size();
                    queueIndex = i;
                }
            }
            ++i;
        }
        if (queueIndex > -1) {
            job = this.getClassesQueues()[queueIndex].peak();
        }
        if (job != null) {
            long result = this.getMapper().sendJob(job.getIndex(), serverID);
            if (result >= 0L) {
                this.getClassesQueues()[queueIndex].dequeue();
            } else {
                job = null;
            }
        }
        return -1;
    }
}

