/*
 * Decompiled with CFR 0.152.
 */
package probability_distribution;

import probability_distribution.ProbabilityDist;

public class ExponentialDist
extends ProbabilityDist {
    protected double lambda;

    protected double getLambda() {
        return this.lambda;
    }

    protected void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public ExponentialDist(double lambda) {
        this.setLambda(lambda);
    }

    protected double f(double x) {
        if (x >= 0.0) {
            return this.getLambda() * Math.exp(-1.0 * this.getLambda() * x);
        }
        return 0.0;
    }

    protected double F(double x) {
        if (x >= 0.0) {
            return 1.0 - Math.exp(-1.0 * this.getLambda() * x);
        }
        return 0.0;
    }

    public double FInverse(double x) {
        return -1.0 * Math.log(x) / this.getLambda();
    }

    public double FInverse() {
        return -1.0 * Math.log(Math.random()) / this.getLambda();
    }

    public static void main(String[] args) {
        boolean TU_InMinutes = true;
        ExponentialDist exp = new ExponentialDist(3.0 / ((double)TU_InMinutes * 60.0 * 1000.0));
        int count = 10000;
        double sum = 0.0;
        int i = 0;
        while (i < count) {
            double x = Math.random();
            double y = exp.getTimeToNextEvent();
            sum += y;
            System.out.print(String.valueOf(x) + "\t" + y + "\n");
            ++i;
        }
        System.out.println("Inter Arival: " + sum / (double)count);
        System.out.println("Rate: " + (double)count / sum + "or Rate: " + (double)count / (sum / 1000.0 / 60.0 / (double)TU_InMinutes) + " Per Time Unit");
        System.out.flush();
    }
}

