/*
 * Decompiled with CFR 0.152.
 */
package probability_distribution;

import probability_distribution.ProbabilityDist;

public class UniformDist
extends ProbabilityDist {
    double lowerLimit;
    double upperLimit;

    public UniformDist(double lowerLimit, double upperLimit) {
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    public UniformDist(double ammount, double percentage, boolean dummy) {
        if (ammount * percentage > 0.0) {
            this.setLowerLimit(ammount * percentage / 2.0 * -1.0);
            this.setUpperLimit(ammount * percentage / 2.0 * 1.0);
        } else {
            this.setLowerLimit(ammount * percentage / 2.0 * 1.0);
            this.setUpperLimit(ammount * percentage / 2.0 * -1.0);
        }
    }

    public UniformDist(double percentage) {
        if (percentage > 0.0) {
            this.setLowerLimit(percentage / 2.0 * -1.0);
            this.setUpperLimit(percentage / 2.0 * 1.0);
        } else {
            this.setLowerLimit(percentage / 2.0 * 1.0);
            this.setUpperLimit(percentage / 2.0 * -1.0);
        }
    }

    private double getLowerLimit() {
        return this.lowerLimit;
    }

    private void setLowerLimit(double lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    private double getUpperLimit() {
        return this.upperLimit;
    }

    private void setUpperLimit(double upperLimit) {
        this.upperLimit = upperLimit;
    }

    public double FInverse(double x) {
        return x * (this.getUpperLimit() - this.getLowerLimit()) + this.getLowerLimit();
    }

    public double FInverse() {
        return Math.random() * (this.getUpperLimit() - this.getLowerLimit()) + this.getLowerLimit();
    }
}

