/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.geo.proj;

import drasys.or.geom.GeomException;
import drasys.or.geom.geo.CoordinateSystem;
import drasys.or.geom.geo.EllipsoidI;
import drasys.or.geom.geo.Point;
import drasys.or.geom.geo.PointI;
import drasys.or.geom.geo.RangeI;
import drasys.or.geom.geo.proj.Conic;
import drasys.or.geom.geo.proj.ConicI;
import drasys.or.geom.geo.proj.ProjectionI;

public class LambertConic
extends Conic
implements ProjectionI,
ConicI {
    double _n;
    double _c;

    public LambertConic(double d, double d2) throws GeomException {
        super(d, d2);
    }

    public LambertConic(RangeI rangeI) throws GeomException {
        super(rangeI);
    }

    public drasys.or.geom.rect2.PointI forward(PointI pointI) throws GeomException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.01745329251994 * pointI.latitude();
        double d4 = 0.01745329251994 * pointI.longitude();
        double d5 = CoordinateSystem.getInstance().getAccuracy();
        double d6 = Math.abs(Math.abs(d3) - 1.5707963267948966) < 1.0E-11 ? 0.0 : this._c * Math.pow(this.tsfn(d3, Math.sin(d3)), this._n);
        d = d6 * Math.sin(d4 *= this._n);
        d2 = d6 * Math.cos(d4);
        return new drasys.or.geom.rect2.Point(d * this._er + this._easting, d2 * this._er + this._northing);
    }

    public PointI inverse(drasys.or.geom.rect2.PointI pointI) throws GeomException {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = (pointI.x() - this._easting) / this._er;
        double d5 = Math.sqrt(d4 * d4 + (d = (pointI.y() - this._northing) / this._er) * d);
        if (d5 != 0.0) {
            if (this._n < 0.0) {
                d5 = -d5;
                d4 = -d4;
                d = -d;
            }
            d3 = this.phi2(Math.pow(d5 / this._c, 1.0 / this._n));
            d2 = Math.atan2(d4, d) / this._n;
        } else {
            d2 = 0.0;
            d3 = this._n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return new Point(d2 / 0.01745329251994, d3 / 0.01745329251994);
    }

    public void setEllipsoid(EllipsoidI ellipsoidI) {
        super.setEllipsoid(ellipsoidI);
        double d = this._n = Math.sin(this._south);
        double d2 = Math.cos(this._south);
        boolean bl = Math.abs(this._north - this._south) >= CoordinateSystem.getInstance().getAccuracy();
        double d3 = this.msfn(d, d2);
        double d4 = this.tsfn(this._south, d);
        if (bl) {
            d = Math.sin(this._north);
            this._n = Math.log(d3 / this.msfn(d, Math.cos(this._north))) / Math.log(d4 / this.tsfn(this._north, d));
        }
        this._c = d3 * Math.pow(d4, -this._n) / this._n;
    }
}

