/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.linear.blas;

import drasys.or.Complex;
import drasys.or.ComplexI;
import drasys.or.Real;
import drasys.or.linear.blas.BLAS1;
import drasys.or.linear.blas.BLAS1I;
import drasys.or.linear.blas.BlasException;
import drasys.or.util.Smp;

public class SmpBLAS1
implements BLAS1I {
    Smp _smp = new Smp(100);
    BLAS1I _blas1 = null;
    BlasException _exception = null;

    public SmpBLAS1() {
        this._blas1 = new BLAS1();
    }

    public SmpBLAS1(BLAS1I bLAS1I) {
        this._blas1 = bLAS1I;
    }

    public void caxpy(int n, ComplexI complexI, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        if (complexI.equals(new Complex())) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.caxpy(n, complexI, fArray, n2, n3, fArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new CaxpyJob(n7, complexI, fArray, n2, n3, fArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void ccopy(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.ccopy(n, fArray, n2, n3, fArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new CcopyJob(n7, fArray, n2, n3, fArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public Complex cdotc(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, Complex complex) throws BlasException {
        if (complex == null) {
            complex = new Complex();
        } else {
            complex.real = 0.0;
            complex.imag = 0.0;
        }
        if (n < 1) {
            return complex;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.cdotc(n, fArray, n2, n3, fArray2, n4, n5, complex);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new CdotcJob(n7, fArray, n2, n3, fArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n8 = 0;
        while (n8 < nArray.length) {
            complex.add(((CdotcJob)runnableArray[n8])._sum);
            ++n8;
        }
        return complex;
    }

    public Complex cdotu(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, Complex complex) throws BlasException {
        if (complex == null) {
            complex = new Complex();
        } else {
            complex.real = 0.0;
            complex.imag = 0.0;
        }
        if (n < 1) {
            return complex;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.cdotu(n, fArray, n2, n3, fArray2, n4, n5, complex);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new CdotuJob(n7, fArray, n2, n3, fArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n8 = 0;
        while (n8 < nArray.length) {
            complex.add(((CdotuJob)runnableArray[n8])._sum);
            ++n8;
        }
        return complex;
    }

    public void cscal(int n, ComplexI complexI, float[] fArray, int n2, int n3) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.cscal(n, complexI, fArray, n2, n3);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new CscalJob(n5, complexI, fArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void csscal(int n, float f, float[] fArray, int n2, int n3) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.csscal(n, f, fArray, n2, n3);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new CsscalJob(n5, f, fArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void cswap(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.cswap(n, fArray, n2, n3, fArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new CswapJob(n7, fArray, n2, n3, fArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public double dasum(int n, double[] dArray, int n2, int n3) throws BlasException {
        double d = 0.0;
        if (n < 1) {
            return 0.0;
        }
        if (n == 1) {
            return Math.abs(dArray[n2]);
        }
        if (n3 == 0) {
            return (double)n * dArray[n2];
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.dasum(n, dArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new DasumJob(n5, dArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n6 = 0;
        while (n6 < nArray.length) {
            d += ((DasumJob)runnableArray[n6])._sum;
            ++n6;
        }
        return d;
    }

    public void daxpy(int n, double d, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        if (d == 0.0) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.daxpy(n, d, dArray, n2, n3, dArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new DaxpyJob(n7, d, dArray, n2, n3, dArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void dcopy(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.dcopy(n, dArray, n2, n3, dArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new DcopyJob(n7, dArray, n2, n3, dArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public double ddot(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) throws BlasException {
        double d = 0.0;
        if (n < 1) {
            return d;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.ddot(n, dArray, n2, n3, dArray2, n4, n5);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new DdotJob(n7, dArray, n2, n3, dArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n8 = 0;
        while (n8 < nArray.length) {
            d += ((DdotJob)runnableArray[n8])._sum;
            ++n8;
        }
        return d;
    }

    public double dnrm2(int n, double[] dArray, int n2, int n3) throws BlasException {
        if (n <= 0 || n3 <= 0) {
            return 0.0;
        }
        if (n == 1) {
            return Math.abs(dArray[n2]);
        }
        double d = 0.0;
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.dnrm2(n, dArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new Dnrm2Job(n5, dArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n6 = 0;
        while (n6 < nArray.length) {
            double d2 = ((Dnrm2Job)runnableArray[n6])._nrm;
            d += d2 * d2;
            ++n6;
        }
        return Math.sqrt(d);
    }

    public void drot(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, double d, double d2) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.drot(n, dArray, n2, n3, dArray2, n4, n5, d, d2);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new DrotJob(n7, dArray, n2, n3, dArray2, n4, n5, d, d2);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void drotg(Real real, Real real2, Real real3, Real real4) throws BlasException {
        this._blas1.drotg(real, real2, real3, real4);
    }

    public void dscal(int n, double d, double[] dArray, int n2, int n3) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.dscal(n, d, dArray, n2, n3);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new DscalJob(n5, d, dArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public double dsdot(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) throws BlasException {
        double d = 0.0;
        if (n < 1) {
            return d;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.dsdot(n, fArray, n2, n3, fArray2, n4, n5);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new DsdotJob(n7, fArray, n2, n3, fArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n8 = 0;
        while (n8 < nArray.length) {
            d += ((DsdotJob)runnableArray[n8])._sum;
            ++n8;
        }
        return d;
    }

    public void dswap(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.dswap(n, dArray, n2, n3, dArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new DswapJob(n7, dArray, n2, n3, dArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public double dzasum(int n, double[] dArray, int n2, int n3) throws BlasException {
        double d = 0.0;
        if (n < 1) {
            return 0.0;
        }
        if (n == 1) {
            return Math.abs(dArray[n2]);
        }
        if (n3 == 0) {
            return (double)n * dArray[n2];
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.dzasum(n, dArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new DzasumJob(n5, dArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n6 = 0;
        while (n6 < nArray.length) {
            d += ((DzasumJob)runnableArray[n6])._sum;
            ++n6;
        }
        return d;
    }

    public double dznrm2(int n, double[] dArray, int n2, int n3) throws BlasException {
        if (n <= 0 || n3 <= 0) {
            return 0.0;
        }
        if (n == 1) {
            return this._blas1.dznrm2(n, dArray, n2, n3);
        }
        double d = 0.0;
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.dznrm2(n, dArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new Dznrm2Job(n5, dArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n6 = 0;
        while (n6 < nArray.length) {
            double d2 = ((Dznrm2Job)runnableArray[n6])._nrm;
            d += d2 * d2;
            ++n6;
        }
        return Math.sqrt(d);
    }

    public Smp getSmp() {
        return this._smp;
    }

    public int icamax(int n, float[] fArray, int n2, int n3) throws BlasException {
        if (n < 1) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        int n4 = n2;
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.icamax(n, fArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n5 = 0;
        int n6 = nArray[0];
        while (n5 < nArray.length) {
            n6 = nArray[n5];
            runnableArray[n5] = new IcamaxJob(n6, fArray, n2, n3);
            n2 += n6 * n3;
            ++n5;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n7 = 2 * ((IcamaxJob)runnableArray[0])._begx + n3 * ((IcamaxJob)runnableArray[0])._idx;
        int n8 = 1;
        while (n8 < nArray.length) {
            int n9 = 2 * ((IcamaxJob)runnableArray[n8])._begx + n3 * ((IcamaxJob)runnableArray[n8])._idx;
            if (Math.abs(fArray[n9]) + Math.abs(fArray[n9 + 1]) > Math.abs(fArray[n7]) + Math.abs(fArray[n7 + 1])) {
                n7 = n9;
            }
            ++n8;
        }
        return (n7 / 2 - n4) / n3;
    }

    public int idamax(int n, double[] dArray, int n2, int n3) throws BlasException {
        int n4;
        if (n < 1) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        int n5 = n2;
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.idamax(n, dArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new IdamaxJob(n7, dArray, n2, n3);
            n2 += n7 * n3;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n8 = n4 = ((IdamaxJob)runnableArray[0])._begx + n3 * ((IdamaxJob)runnableArray[0])._idx;
        int n9 = 1;
        while (n9 < nArray.length) {
            n4 = ((IdamaxJob)runnableArray[n9])._begx + n3 * ((IdamaxJob)runnableArray[n9])._idx;
            if (Math.abs(dArray[n4]) > Math.abs(dArray[n8])) {
                n8 = n4;
            }
            ++n9;
        }
        return (n8 - n5) / n3;
    }

    public int isamax(int n, float[] fArray, int n2, int n3) throws BlasException {
        if (n < 1) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        int n4 = n2;
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.isamax(n, fArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n5 = 0;
        int n6 = nArray[0];
        while (n5 < nArray.length) {
            n6 = nArray[n5];
            runnableArray[n5] = new IsamaxJob(n6, fArray, n2, n3);
            n2 += n6 * n3;
            ++n5;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n7 = ((IsamaxJob)runnableArray[0])._begx + n3 * ((IsamaxJob)runnableArray[0])._idx;
        int n8 = 1;
        while (n8 < nArray.length) {
            int n9 = ((IsamaxJob)runnableArray[n8])._begx + n3 * ((IsamaxJob)runnableArray[n8])._idx;
            if (Math.abs(fArray[n9]) > Math.abs(fArray[n7])) {
                n7 = n9;
            }
            ++n8;
        }
        return (n7 - n4) / n3;
    }

    public int izamax(int n, double[] dArray, int n2, int n3) throws BlasException {
        if (n < 1) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        int n4 = n2;
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.izamax(n, dArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n5 = 0;
        int n6 = nArray[0];
        while (n5 < nArray.length) {
            n6 = nArray[n5];
            runnableArray[n5] = new IzamaxJob(n6, dArray, n2, n3);
            n2 += n6 * n3;
            ++n5;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n7 = 2 * ((IzamaxJob)runnableArray[0])._begx + n3 * ((IzamaxJob)runnableArray[0])._idx;
        int n8 = 1;
        while (n8 < nArray.length) {
            int n9 = 2 * ((IzamaxJob)runnableArray[n8])._begx + n3 * ((IzamaxJob)runnableArray[n8])._idx;
            if (Math.abs(dArray[n9]) + Math.abs(dArray[n9 + 1]) > Math.abs(dArray[n7]) + Math.abs(dArray[n7 + 1])) {
                n7 = n9;
            }
            ++n8;
        }
        return (n7 / 2 - n4) / n3;
    }

    public float sasum(int n, float[] fArray, int n2, int n3) throws BlasException {
        float f = 0.0f;
        if (n < 1) {
            return 0.0f;
        }
        if (n == 1) {
            return Math.abs(fArray[n2]);
        }
        if (n3 == 0) {
            return (float)n * fArray[n2];
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.sasum(n, fArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new SasumJob(n5, fArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n6 = 0;
        while (n6 < nArray.length) {
            f += ((SasumJob)runnableArray[n6])._sum;
            ++n6;
        }
        return f;
    }

    public void saxpy(int n, float f, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        if ((double)f == 0.0) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.saxpy(n, f, fArray, n2, n3, fArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new SaxpyJob(n7, f, fArray, n2, n3, fArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public float scasum(int n, float[] fArray, int n2, int n3) throws BlasException {
        float f = 0.0f;
        if (n < 1) {
            return 0.0f;
        }
        if (n == 1) {
            return Math.abs(fArray[n2]);
        }
        if (n3 == 0) {
            return (float)n * fArray[n2];
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.scasum(n, fArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new ScasumJob(n5, fArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n6 = 0;
        while (n6 < nArray.length) {
            f += ((ScasumJob)runnableArray[n6])._sum;
            ++n6;
        }
        return f;
    }

    public float scnrm2(int n, float[] fArray, int n2, int n3) throws BlasException {
        if (n <= 0 || n3 <= 0) {
            return 0.0f;
        }
        if (n == 1) {
            return this._blas1.scnrm2(n, fArray, n2, n3);
        }
        float f = 0.0f;
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.scnrm2(n, fArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new Scnrm2Job(n5, fArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n6 = 0;
        while (n6 < nArray.length) {
            float f2 = ((Scnrm2Job)runnableArray[n6])._nrm;
            f += f2 * f2;
            ++n6;
        }
        return (float)Math.sqrt(f);
    }

    public void scopy(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.scopy(n, fArray, n2, n3, fArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new ScopyJob(n7, fArray, n2, n3, fArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public float sdot(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) throws BlasException {
        float f = 0.0f;
        if (n < 1) {
            return f;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.sdot(n, fArray, n2, n3, fArray2, n4, n5);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new SdotJob(n7, fArray, n2, n3, fArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n8 = 0;
        while (n8 < nArray.length) {
            f += ((SdotJob)runnableArray[n8])._sum;
            ++n8;
        }
        return f;
    }

    public float sdsdot(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) throws BlasException {
        double d = 0.0;
        if (n < 1) {
            return 0.0f;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.sdsdot(n, fArray, n2, n3, fArray2, n4, n5);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new SdsdotJob(n7, fArray, n2, n3, fArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n8 = 0;
        while (n8 < nArray.length) {
            d += ((SdsdotJob)runnableArray[n8])._sum;
            ++n8;
        }
        return (float)d;
    }

    public void setSmp(Smp smp) {
        this._smp = smp;
    }

    public float snrm2(int n, float[] fArray, int n2, int n3) throws BlasException {
        if (n <= 0 || n3 <= 0) {
            return 0.0f;
        }
        if (n == 1) {
            return Math.abs(fArray[n2]);
        }
        float f = 0.0f;
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.snrm2(n, fArray, n2, n3);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new Snrm2Job(n5, fArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n6 = 0;
        while (n6 < nArray.length) {
            float f2 = ((Snrm2Job)runnableArray[n6])._nrm;
            f += f2 * f2;
            ++n6;
        }
        return (float)Math.sqrt(f);
    }

    public void srot(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, float f, float f2) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.srot(n, fArray, n2, n3, fArray2, n4, n5, f, f2);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new SrotJob(n7, fArray, n2, n3, fArray2, n4, n5, f, f2);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void srotg(Real real, Real real2, Real real3, Real real4) throws BlasException {
        this._blas1.srotg(real, real2, real3, real4);
    }

    public void sscal(int n, float f, float[] fArray, int n2, int n3) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.sscal(n, f, fArray, n2, n3);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new SscalJob(n5, f, fArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void sswap(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.sswap(n, fArray, n2, n3, fArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new SswapJob(n7, fArray, n2, n3, fArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void zaxpy(int n, ComplexI complexI, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        if (complexI.equals(new Complex())) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.zaxpy(n, complexI, dArray, n2, n3, dArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new ZaxpyJob(n7, complexI, dArray, n2, n3, dArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void zcopy(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.zcopy(n, dArray, n2, n3, dArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new ZcopyJob(n7, dArray, n2, n3, dArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public Complex zdotc(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, Complex complex) throws BlasException {
        if (complex == null) {
            complex = new Complex();
        } else {
            complex.real = 0.0;
            complex.imag = 0.0;
        }
        if (n < 1) {
            return complex;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.zdotc(n, dArray, n2, n3, dArray2, n4, n5, complex);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new ZdotcJob(n7, dArray, n2, n3, dArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n8 = 0;
        while (n8 < nArray.length) {
            complex.add(((ZdotcJob)runnableArray[n8])._sum);
            ++n8;
        }
        return complex;
    }

    public Complex zdotu(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, Complex complex) throws BlasException {
        if (complex == null) {
            complex = new Complex();
        } else {
            complex.real = 0.0;
            complex.imag = 0.0;
        }
        if (n < 1) {
            return complex;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            return this._blas1.zdotu(n, dArray, n2, n3, dArray2, n4, n5, complex);
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new ZdotuJob(n7, dArray, n2, n3, dArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
        int n8 = 0;
        while (n8 < nArray.length) {
            complex.add(((ZdotuJob)runnableArray[n8])._sum);
            ++n8;
        }
        return complex;
    }

    public void zdscal(int n, double d, double[] dArray, int n2, int n3) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.zdscal(n, d, dArray, n2, n3);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new ZdscalJob(n5, d, dArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void zscal(int n, ComplexI complexI, double[] dArray, int n2, int n3) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.zscal(n, complexI, dArray, n2, n3);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n4 = 0;
        int n5 = nArray[0];
        while (n4 < nArray.length) {
            n5 = nArray[n4];
            runnableArray[n4] = new ZscalJob(n5, complexI, dArray, n2, n3);
            n2 += n5 * n3;
            ++n4;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void zswap(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) throws BlasException {
        if (n < 1) {
            return;
        }
        int[] nArray = this._smp.balanceTasks(n, 1);
        if (nArray.length < 2) {
            this._blas1.zswap(n, dArray, n2, n3, dArray2, n4, n5);
            return;
        }
        Runnable[] runnableArray = new Runnable[nArray.length];
        int n6 = 0;
        int n7 = nArray[0];
        while (n6 < nArray.length) {
            n7 = nArray[n6];
            runnableArray[n6] = new ZswapJob(n7, dArray, n2, n3, dArray2, n4, n5);
            n2 += n7 * n3;
            n4 += n7 * n5;
            ++n6;
        }
        this._exception = null;
        try {
            Smp.schedule(runnableArray.length, runnableArray, 1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new BlasException("Interrupted: " + interruptedException.getMessage());
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    private class DasumJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        double _sum;
        double[] _x;
        double[] _y;

        DasumJob(int n, double[] dArray, int n2, int n3) {
            this._n = n;
            this._sum = 0.0;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.dasum(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class IdamaxJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _idx;
        double[] _x;
        double[] _y;

        IdamaxJob(int n, double[] dArray, int n2, int n3) {
            this._n = n;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._idx = SmpBLAS1.this._blas1.idamax(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class IzamaxJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _idx;
        double[] _x;
        double[] _y;

        IzamaxJob(int n, double[] dArray, int n2, int n3) {
            this._n = n;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._idx = SmpBLAS1.this._blas1.izamax(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class IsamaxJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _idx;
        float[] _x;
        float[] _y;

        IsamaxJob(int n, float[] fArray, int n2, int n3) {
            this._n = n;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._idx = SmpBLAS1.this._blas1.isamax(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class IcamaxJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _idx;
        float[] _x;
        float[] _y;

        IcamaxJob(int n, float[] fArray, int n2, int n3) {
            this._n = n;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._idx = SmpBLAS1.this._blas1.icamax(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class DzasumJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        double _sum;
        double[] _x;
        double[] _y;

        DzasumJob(int n, double[] dArray, int n2, int n3) {
            this._n = n;
            this._sum = 0.0;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.dzasum(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class DaxpyJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        double _alpha;
        double[] _x;
        double[] _y;

        DaxpyJob(int n, double d, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
            this._n = n;
            this._alpha = d;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
            this._y = dArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.daxpy(this._n, this._alpha, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class DcopyJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        double[] _x;
        double[] _y;

        DcopyJob(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
            this._n = n;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
            this._y = dArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.dcopy(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class DdotJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        double _sum;
        double[] _x;
        double[] _y;

        DdotJob(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
            this._n = n;
            this._sum = 0.0;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
            this._y = dArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.ddot(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class DrotJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        double _cos;
        double _sin;
        double[] _x;
        double[] _y;

        DrotJob(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, double d, double d2) {
            this._n = n;
            this._sin = d2;
            this._cos = d;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
            this._y = dArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.drot(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy, this._cos, this._sin);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class DscalJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        double _alpha;
        double[] _x;
        double[] _y;

        DscalJob(int n, double d, double[] dArray, int n2, int n3) {
            this._n = n;
            this._alpha = d;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.dscal(this._n, this._alpha, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class ZdscalJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        double _alpha;
        double[] _x;
        double[] _y;

        ZdscalJob(int n, double d, double[] dArray, int n2, int n3) {
            this._n = n;
            this._alpha = d;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.zdscal(this._n, this._alpha, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class DswapJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        double[] _x;
        double[] _y;

        DswapJob(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
            this._n = n;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
            this._y = dArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.dswap(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class Dnrm2Job
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        double _nrm;
        double[] _x;
        double[] _y;

        Dnrm2Job(int n, double[] dArray, int n2, int n3) {
            this._n = n;
            this._nrm = 0.0;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._nrm = SmpBLAS1.this._blas1.dnrm2(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class Dznrm2Job
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        double _nrm;
        double[] _x;
        double[] _y;

        Dznrm2Job(int n, double[] dArray, int n2, int n3) {
            this._n = n;
            this._nrm = 0.0;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._nrm = SmpBLAS1.this._blas1.dznrm2(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class SasumJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        float _sum;
        float[] _x;
        float[] _y;

        SasumJob(int n, float[] fArray, int n2, int n3) {
            this._n = n;
            this._sum = 0.0f;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.sasum(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class ScasumJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        float _sum;
        float[] _x;
        float[] _y;

        ScasumJob(int n, float[] fArray, int n2, int n3) {
            this._n = n;
            this._sum = 0.0f;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.scasum(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class SaxpyJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        float _alpha;
        float[] _x;
        float[] _y;

        SaxpyJob(int n, float f, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) {
            this._n = n;
            this._alpha = f;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.saxpy(this._n, this._alpha, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class ScopyJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        float[] _x;
        float[] _y;

        ScopyJob(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) {
            this._n = n;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.scopy(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class SdotJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        float _sum;
        float[] _x;
        float[] _y;

        SdotJob(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) {
            this._n = n;
            this._sum = 0.0f;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.sdot(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class DsdotJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        double _sum;
        float[] _x;
        float[] _y;

        DsdotJob(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) {
            this._n = n;
            this._sum = 0.0;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.dsdot(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class SdsdotJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        double _sum;
        float[] _x;
        float[] _y;

        SdsdotJob(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) {
            this._n = n;
            this._sum = 0.0;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.sdsdot(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class SrotJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        float _cos;
        float _sin;
        float[] _x;
        float[] _y;

        SrotJob(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, float f, float f2) {
            this._n = n;
            this._sin = f2;
            this._cos = f;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.srot(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy, this._cos, this._sin);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class SscalJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        float _alpha;
        float[] _x;
        float[] _y;

        SscalJob(int n, float f, float[] fArray, int n2, int n3) {
            this._n = n;
            this._alpha = f;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.sscal(this._n, this._alpha, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class CsscalJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        float _alpha;
        float[] _x;
        float[] _y;

        CsscalJob(int n, float f, float[] fArray, int n2, int n3) {
            this._n = n;
            this._alpha = f;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.csscal(this._n, this._alpha, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class SswapJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        float[] _x;
        float[] _y;

        SswapJob(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) {
            this._n = n;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.sswap(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class Snrm2Job
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        float _nrm;
        float[] _x;
        float[] _y;

        Snrm2Job(int n, float[] fArray, int n2, int n3) {
            this._n = n;
            this._nrm = 0.0f;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._nrm = SmpBLAS1.this._blas1.snrm2(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class Scnrm2Job
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        float _nrm;
        float[] _x;
        float[] _y;

        Scnrm2Job(int n, float[] fArray, int n2, int n3) {
            this._n = n;
            this._nrm = 0.0f;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                this._nrm = SmpBLAS1.this._blas1.scnrm2(this._n, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class ZaxpyJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        ComplexI _alpha;
        double[] _x;
        double[] _y;

        ZaxpyJob(int n, ComplexI complexI, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
            this._n = n;
            this._alpha = complexI;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
            this._y = dArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.zaxpy(this._n, this._alpha, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class ZcopyJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        double[] _x;
        double[] _y;

        ZcopyJob(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
            this._n = n;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
            this._y = dArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.zcopy(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class ZdotuJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        Complex _sum;
        double[] _x;
        double[] _y;

        ZdotuJob(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
            this._n = n;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
            this._y = dArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.zdotu(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy, new Complex());
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class ZdotcJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        Complex _sum;
        double[] _x;
        double[] _y;

        ZdotcJob(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
            this._n = n;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
            this._y = dArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.zdotc(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy, new Complex());
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class ZscalJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        ComplexI _alpha;
        double[] _x;
        double[] _y;

        ZscalJob(int n, ComplexI complexI, double[] dArray, int n2, int n3) {
            this._n = n;
            this._alpha = complexI;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.zscal(this._n, this._alpha, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class ZswapJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        double[] _x;
        double[] _y;

        ZswapJob(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
            this._n = n;
            this._x = dArray;
            this._begx = n2;
            this._incx = n3;
            this._y = dArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.zswap(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class CaxpyJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        ComplexI _alpha;
        float[] _x;
        float[] _y;

        CaxpyJob(int n, ComplexI complexI, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) {
            this._n = n;
            this._alpha = complexI;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.caxpy(this._n, this._alpha, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class CcopyJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        float[] _x;
        float[] _y;

        CcopyJob(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) {
            this._n = n;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.ccopy(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class CdotuJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        Complex _sum;
        float[] _x;
        float[] _y;

        CdotuJob(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) {
            this._n = n;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.cdotu(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy, new Complex());
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class CdotcJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        Complex _sum;
        float[] _x;
        float[] _y;

        CdotcJob(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) {
            this._n = n;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                this._sum = SmpBLAS1.this._blas1.cdotc(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy, new Complex());
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class CscalJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        ComplexI _alpha;
        float[] _x;
        float[] _y;

        CscalJob(int n, ComplexI complexI, float[] fArray, int n2, int n3) {
            this._n = n;
            this._alpha = complexI;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.cscal(this._n, this._alpha, this._x, this._begx, this._incx);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }

    private class CswapJob
    implements Runnable {
        int _n;
        int _begx;
        int _incx;
        int _begy;
        int _incy;
        float[] _x;
        float[] _y;

        CswapJob(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5) {
            this._n = n;
            this._x = fArray;
            this._begx = n2;
            this._incx = n3;
            this._y = fArray2;
            this._begy = n4;
            this._incy = n5;
        }

        public void run() {
            try {
                SmpBLAS1.this._blas1.cswap(this._n, this._x, this._begx, this._incx, this._y, this._begy, this._incy);
            }
            catch (BlasException blasException) {
                SmpBLAS1.this._exception = blasException;
            }
        }
    }
}

