/*
 * Decompiled with CFR 0.152.
 */
package generating;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import logging.Logger;
import mapping.Mapper;
import mapping.data.Job;

public class TestRepeater
implements Runnable {
    private static final DateFormat FORMATTER = DateFormat.getDateTimeInstance();
    private boolean alive;
    private LinkedList<GenerationNode> list;
    private GregorianCalendar startOfOriginalTest;
    private GregorianCalendar startOfNewTest;
    private Thread thisThread;
    private Mapper mapper;
    private Logger logger;

    public TestRepeater(String fileName, GregorianCalendar startOfThisTest, Mapper mapper) {
        block23: {
            this.alive = true;
            this.list = new LinkedList();
            this.startOfNewTest = startOfThisTest;
            this.setMapper(mapper);
            this.setLogger(new Logger("generating"));
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            String line = null;
            try {
                fileReader = new FileReader(new File(fileName));
                bufferedReader = new BufferedReader(fileReader);
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.trim().charAt(0) != '@') continue;
                    this.startOfOriginalTest = TestRepeater.convertStringToDate(line.trim().substring(2));
                    break;
                }
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.trim().charAt(0) == '#') continue;
                    this.insertNode(line);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (fileReader != null) {
                        fileReader.close();
                    }
                    break block23;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                break block23;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block23;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (fileReader != null) {
                            fileReader.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.print(this.list.toString());
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void startThread() {
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.thisThread.interrupt();
        this.thisThread = null;
    }

    public void run() {
        GregorianCalendar now = new GregorianCalendar();
        if (now.after(this.startOfNewTest)) {
            System.out.print("Problem");
            return;
        }
        try {
            Thread.sleep(this.startOfNewTest.getTimeInMillis() - now.getTimeInMillis());
            this.getLogger().log("");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long sleepTime = 0L;
        while (this.isAlive() && !this.list.isEmpty()) {
            GenerationNode node = this.list.remove();
            now = new GregorianCalendar();
            sleepTime = node.cal.getTimeInMillis() - now.getTimeInMillis();
            if (sleepTime <= 0L) {
                sleepTime = 1L;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.generateJob(node.classID, node.executionTime);
        }
    }

    private void generateJob(int classID, long executionTime) {
        Job job = new Job(classID, executionTime);
        this.getMapper().submitJob(job);
        System.out.println("Task generated from class: " + classID + "\texecutionTime: " + executionTime);
        this.getLogger().log("Task generated from class: " + classID + "\texecutionTime: " + executionTime);
    }

    public void insertNode(String line) {
        GregorianCalendar newCal = new GregorianCalendar();
        int index1 = 0;
        int index2 = 0;
        int i = 0;
        if (i < line.length()) {
            while (!Character.isDigit(line.charAt(i))) {
                ++i;
            }
            index1 = i;
            while (Character.isDigit(line.charAt(i))) {
                index2 = i++;
            }
            int classID = Integer.parseInt(line.substring(index1, index2 + 1));
            while (!Character.isDigit(line.charAt(i))) {
                ++i;
            }
            index1 = i;
            while (Character.isDigit(line.charAt(i))) {
                index2 = i++;
            }
            int executionTime = Integer.parseInt(line.substring(index1, index2 + 1));
            while (line.charAt(i) != '@') {
                ++i;
            }
            GregorianCalendar originalCal = TestRepeater.convertStringToDate(line.substring(++i));
            newCal.setTimeInMillis(this.startOfNewTest.getTimeInMillis() + (originalCal.getTimeInMillis() - this.startOfOriginalTest.getTimeInMillis()));
            this.addSorted(newCal, classID, executionTime);
            return;
        }
    }

    private void addSorted(GregorianCalendar cal, int classID, long executionTime) {
        GenerationNode node = new GenerationNode(cal, classID, executionTime);
        if (this.list.isEmpty()) {
            this.list.add(node);
            return;
        }
        int i = 0;
        while (i < this.list.size()) {
            if (node.cal.before(this.list.get((int)i).cal)) {
                this.list.add(i, node);
                return;
            }
            ++i;
        }
        this.list.add(node);
    }

    public static GregorianCalendar convertStringToDate(String dateString) {
        Date d = null;
        try {
            d = FORMATTER.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        return cal;
    }

    public static void main(String[] args) {
    }

    public static class GenerationNode {
        GregorianCalendar cal;
        int classID;
        long executionTime;

        public GenerationNode(GregorianCalendar cal, int classID, long executionTime) {
            this.cal = cal;
            this.classID = classID;
            this.executionTime = executionTime;
        }

        public String toString() {
            return "Task generated from class:" + this.classID + "\t" + "executionTime: " + this.executionTime + "\t a" + this.cal.getTime().toString() + "\n";
        }
    }
}

