/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import java.util.GregorianCalendar;
import mapping.JobsQueue;
import mapping.LPAS_DG_MS_SOLVING_TICKER;
import mapping.LPAS_DG_MS_ThreadRB;
import mapping.LP_Solver;
import mapping.Mapper;
import mapping.MappingScheme;
import mapping.data.DeltaStar;
import mapping.data.Job;
import mapping.data.Server;

public class LPAS_DG_MS
extends MappingScheme {
    private static final long serialVersionUID = -6903975517099008321L;
    private JobsQueue[] classesQueues;
    private DeltaStar deltaStar;
    private LPAS_DG_MS_ThreadRB helperThread;
    private LPAS_DG_MS_SOLVING_TICKER ticker;
    private Thread thread;
    static final int ALL_QUEUES_ARE_EMPTY = -5;
    static final int NO_JOB_IN_QUEUE_IS_SUITABLE_FOR_SERVER = -4;
    static final int SUTIABLE_JOB_FOUND_BUT_COULD_NOT_BE_SENT = -3;
    static final int FATAL_ERROR = -1;
    static final int SUCCESS = 1;
    static final long QUEUE_IS_EMPTY = -2L;

    public LPAS_DG_MS(Mapper mapper) {
        super(mapper);
        this.setDescription("LPAS_DG");
    }

    public JobsQueue[] getClassesQueues() {
        return this.classesQueues;
    }

    public void setClassesQueues(JobsQueue[] classesQueues) {
        this.classesQueues = classesQueues;
    }

    public synchronized DeltaStar getDeltaStar() {
        return this.deltaStar;
    }

    public synchronized void setDeltaStar(DeltaStar deltaStar) {
        this.deltaStar = deltaStar;
    }

    private LPAS_DG_MS_ThreadRB getHelperThread() {
        return this.helperThread;
    }

    private void setHelperThread(LPAS_DG_MS_ThreadRB helperThread) {
        this.helperThread = helperThread;
    }

    public LPAS_DG_MS_SOLVING_TICKER getTicker() {
        return this.ticker;
    }

    private void setTicker(LPAS_DG_MS_SOLVING_TICKER ticker) {
        this.ticker = ticker;
    }

    protected Thread getThread() {
        return this.thread;
    }

    protected void setThread(Thread thread) {
        this.thread = thread;
    }

    public void startMappingScheme() {
        try {
            DeltaStar delta = LP_Solver.solveWithAj(this.getMapper().getServersTable(), this.getMapper().getClassesTable());
            this.setDeltaStar(delta);
            this.initQueues();
            this.setTicker(new LPAS_DG_MS_SOLVING_TICKER(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setHelperThread(new LPAS_DG_MS_ThreadRB(this));
        this.getHelperThread().startThread();
        this.getTicker().startThread();
    }

    public void stopMappingScheme() {
        this.getHelperThread().stopThread();
        this.getTicker().stopThread();
    }

    protected void mapJob(Job job) {
        int jobClassID = this.getMapper().getJobsTable().getJobClassID(job.getIndex());
        this.getClassesQueues()[jobClassID - 1].enqueue(job);
    }

    public void handleJobTimeOut(long jobID) {
        this.getMapper().getJobsTable().setTimedOut(jobID, true);
        this.getMapper().getJobsTable().setJobServer(jobID, null);
        this.getMapper().resubmitJob((Job)this.getMapper().getJobsTable().get(jobID));
    }

    public void serverIsDown(int serverID) {
        this.refreshDeltaStar();
        System.err.println("LPAS_DG knows that server:" + serverID + " is DOWN.\n--------");
    }

    public void serverIsUp(int serverID) {
        this.refreshDeltaStar();
        System.err.println("LPAS_DG knows that server:" + serverID + " is UP.\n--------");
    }

    protected void refreshDeltaStar() {
        try {
            this.setDeltaStar(LP_Solver.solveWithAj(this.getMapper().getServersTable(), this.getMapper().getClassesTable()));
            this.getDeltaStar().printAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printQueues() {
        int i = 0;
        while (i < this.getClassesQueues().length) {
            System.out.println("Queue " + (i + 1) + ":");
            this.getClassesQueues()[i].print();
            ++i;
        }
        System.out.println("\n\n");
    }

    protected String getQueuesString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.getClassesQueues().length) {
            buf.append("Queue " + (i + 1) + ": \n");
            buf.append(this.getClassesQueues()[i].toString());
            ++i;
        }
        return buf.toString();
    }

    public void initQueues() {
        this.classesQueues = new JobsQueue[this.getMapper().getClassesTable().size()];
        int i = 0;
        while (i < this.getMapper().getClassesTable().size()) {
            this.classesQueues[i] = new JobsQueue();
            ++i;
        }
    }

    protected int sendJobForServer(int availableServer) {
        int queuesThatHasItLeastOnJob = 0;
        double max = -1.0;
        int queueIndex = 0;
        long DiOfT = -1L;
        long nowInMillis = new GregorianCalendar().getTimeInMillis();
        Job job = null;
        Server server = (Server)this.getMapper().getServersTable().get(availableServer);
        int i = 0;
        while (i < this.getClassesQueues().length) {
            double Uij = server.getAssumedRate(i + 1);
            if (this.getClassesQueues()[i].size() > 0) {
                ++queuesThatHasItLeastOnJob;
                long timeSubmittedInMillis = this.getMapper().getJobsTable().getJobTimeSubmitted(this.getClassesQueues()[i].peak().getIndex()).getTimeInMillis();
                DiOfT = nowInMillis - timeSubmittedInMillis;
            } else {
                DiOfT = -2L;
            }
            if (!this.getDeltaStar().isZero(i, availableServer - 1) && Uij * (double)DiOfT > max) {
                max = Uij * (double)DiOfT;
                queueIndex = i;
            }
            ++i;
        }
        if (queuesThatHasItLeastOnJob == 0) {
            return -5;
        }
        if (max == -1.0 && queuesThatHasItLeastOnJob > 0) {
            return -4;
        }
        job = this.getClassesQueues()[queueIndex].peak();
        if (job != null) {
            long result = this.getMapper().sendJob(job.getIndex(), availableServer);
            if (result >= 0L) {
                this.getClassesQueues()[queueIndex].dequeue();
                return 1;
            }
            return -3;
        }
        System.out.println("LPAS_DG_MS.sendJobForServer(): FATAL_ERROR");
        return -1;
    }
}

