/*
 * Decompiled with CFR 0.152.
 */
package mapping;

import mapping.FCFS_MS;
import mapping.data.IDsQueue;
import mapping.data.Server;

public class TWOREP_MS_Thread
implements Runnable {
    private boolean alive = true;
    private int[] serverIDs = new int[2];
    private Server[] server = new Server[2];
    private int[] results = new int[2];
    private Thread thisThread;
    private FCFS_MS fcfs_ms;

    public TWOREP_MS_Thread(FCFS_MS fcfs_ms) {
        this.setAlive(true);
        this.setFCFS_MS(fcfs_ms);
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    public FCFS_MS getFCFS_MS() {
        return this.fcfs_ms;
    }

    public void setFCFS_MS(FCFS_MS Fcfs_ms) {
        this.fcfs_ms = Fcfs_ms;
    }

    public void startThread() {
        System.out.println("Two Replication Thread started");
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopThread() {
        this.setAlive(false);
        this.thisThread.interrupt();
        this.thisThread = null;
    }

    public boolean arrayisFull(int[] array) {
        boolean Full = true;
        int i = 0;
        while (i < array.length) {
            if (array[i] == 0) {
                Full = false;
            }
            ++i;
        }
        return Full;
    }

    public boolean failuresOccur() {
        boolean Fail = false;
        int i = 0;
        while (i < this.results.length) {
            if (this.results[i] < 0) {
                Fail = true;
            }
            ++i;
        }
        return Fail;
    }

    public boolean readyforJobSubmission() {
        boolean ready = true;
        if (!this.arrayisFull(this.serverIDs)) {
            ready = false;
        }
        int i = 0;
        while (i < this.server.length) {
            if (this.server[i].getNumberOfActiveJobs() != 0 || this.getFCFS_MS().getMapper().getServersTable().isServerDown(this.serverIDs[i])) {
                ready = false;
            }
            ++i;
        }
        return ready;
    }

    public void run() {
        int i = 0;
        IDsQueue<Integer> q = this.getFCFS_MS().getMapper().getAvailableServersQueue();
        while (this.isAlive()) {
            if (q.isEmpty()) continue;
            if (i < this.serverIDs.length) {
                this.serverIDs[i] = q.getVal((int)(Math.random() * (double)q.getRowCount()));
                ++i;
            }
            if (this.arrayisFull(this.serverIDs)) {
                i = 0;
                while (i < this.serverIDs.length) {
                    this.server[i] = (Server)this.getFCFS_MS().getMapper().getServersTable().get(this.serverIDs[i]);
                    ++i;
                }
            }
            if (this.readyforJobSubmission()) {
                i = 0;
                while (i < this.results.length) {
                    this.results[i] = this.getFCFS_MS().sendJobForServer(this.serverIDs[i]);
                    ++i;
                }
                if (!this.failuresOccur()) continue;
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    if (this.isAlive()) continue;
                    return;
                }
            }
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

