package arrival_generator;

/**
 * To add a new Workload scheme, A concrete class that extends this class
 * must be used an must implement the following methods.
 * 
 * This class determines what services should be provided to a concrete
 * arrival generator class
 * 
 * @author Ben Kybartas
 * 
 */
public abstract class ArrivalGenerator
{
	/**
	 * Provide a description for the arrival generator used 
	 */
	public String description;
	
	
	public String getDescription()
	{
		return description;
	}
	
	public void setDescription(String description)
	{
		this.description = description;
	}
	
	/**
	 * Only one method should be used in a new workload scheme, each time it is called it
	 * will return an array which contains the following information in order
	 * JobClassID, Arrival Rate, Execution Time
	 * 
	 */
	public abstract long[] getNextJobInfo();
	
	/**
	 * Used to close the jobLogger, if it is being used
	 */
	public abstract void closeLogger();
}
	