package interfacing;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

/**
 * This class is a JPanel able to view the available servers during a test.
 * 
 * @author Majd Kokaly
 *
 */

public class AvailableServerQueueJPanel extends JPanel {
	/**
	 * The serialVersionUID is used to universally identify this version of this
	 * class.
	 */
	private static final long serialVersionUID = 6757094722127878322L;	
	
	/**
	 * This is the main frame containing all the GUI components. A reference is needed to be able to access the mapper and its data
	 */
	MainFrame frame;
	
	/**
	 * The JTable object containing the list of servers.
	 */
	private JTable jTable;
	
	/**
	 * The JButton that has to be clicked in order for this JPanel to get the available servers. 
	 */
	private JButton buttonUpdate = new JButton("Update");
	
	/**
	 * All the icons are stored in the folder named iconsFolder
	 */
	String iconsFolder = "Icons";
	
	/**
	 * 
	 * @param model TableModel object
	 */
	protected void setModelForJTable(TableModel model) {
		this.jTable.setModel(model);
	}
	
	/**
	 * This is the default constructor
	 * @param frame
	 */
	public AvailableServerQueueJPanel(final MainFrame frame) {
		this.frame = frame;
		this.setLayout(new BorderLayout());
		// Setting this queue as the model makes the jTable view the list of servers
		jTable = new JTable(this.frame.getMapper().getAvailableServersQueue());
		JScrollPane scrollPane = new JScrollPane(jTable);
			
		JPanel buttonsPanel = new JPanel();
		buttonsPanel.add(buttonUpdate);		
	
		this.buttonUpdate.setIcon(new ImageIcon(iconsFolder + "/" + "reload_22.png"));
		
		this.add(scrollPane, BorderLayout.CENTER);
		this.add(buttonsPanel, BorderLayout.NORTH);
		
		
		this.buttonUpdate.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				repaint();
			}
		});
	}
}
