package interfacing;

import javax.swing.table.DefaultTableModel;

/**
 * This class is a DefaultTableModel with ability to be set to be editable or
 * not.
 * 
 * @author Majd Kokaly
 * 
 */
public class OurDefaultTableModel extends DefaultTableModel {
	
	/**
	 * The serialVersionUID is used to universally identify this version of this class. 
	 */
	private static final long serialVersionUID = -1697783110656092098L;

	/**
	 * This boolean value determines if the table that this object is model for
	 * is editable or not
	 */
	private boolean editable = true;
	
	/**
	 * Default constructor
	 * @param cols is a string containing the names of the columns.
	 * @param rows is the numbers of rows
	 */
	public OurDefaultTableModel(String[] cols, int rows) {
		super(cols, rows);
	}

	public boolean isEditable() {
		return editable;
	}

	public void setEditable(boolean editable) {
		this.editable = editable;
	}

	/**
	 * To prevent editing the id column or when not editable (i.e. editable = false).
	 */
	public boolean isCellEditable(int row, int column) {
		if (!editable || column == 0) {
			return false;
		} else
			return true;
	}
}
