package logging;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

import mapping.Mapper;
import mapping.data.JobClass;
import mapping.data.JobClassesTable;
import mapping.data.ServersTable;

/**
 * This class is used to read a file containing a mue matrix.
 * 
 * 
 * 
 * @author Majd Kokaly
 * 
 */
public class MueReader {

	/**
	 * This method is used to read a Mue Matrix from a file and set the assumed
	 * rates accordingly.
	 * 
	 * @param mapper
	 *            The mapper object which has the classesTable and serversTable.
	 * @param fileName
	 *            The file containing the matrix.
	 * @throws Exception
	 *             An exception is thrown when the mue matrix file has no valid
	 *             format.
	 */
	static public void readMue(Mapper mapper, String fileName) throws Exception {

		String line = null;
		BufferedReader bufferedReader = null;
		FileReader fileReader = null;
		StringTokenizer tokenizer = null;
		double d;
		int i = 1, j = 1;
		;
		try {
			fileReader = new FileReader(fileName);
			bufferedReader = new BufferedReader(fileReader);
			while ((line = bufferedReader.readLine()) != null) {
				tokenizer = new StringTokenizer(line, ",");
				while (tokenizer.hasMoreTokens()) {
					d = Double.parseDouble(tokenizer.nextToken());

					mapper.setAssumedRate(j, i, d);
					j++;
				}
				j = 1;
				i++;
			}
		} catch (IOException e) {
			throw e;
		}

	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		Mapper m = new Mapper();

		JobClassesTable table = new JobClassesTable();
		table.addJobClass(new JobClass(2.25, 500));
		table.addJobClass(new JobClass(4.5, 500));
		table.addJobClass(new JobClass(7.2, 500));
		table.addJobClass(new JobClass(12.6, 500));

		m.setClassesTable(table);

		ServersTable serversTable = new ServersTable();

		ServersReader.readServersFromFile("Servers/servers21.srs", serversTable);

		m.setServersTable(serversTable);

		m.print();

		m.fillProcessingRates();

		m.setAssumedRate(1, 1, 0.7);

		try {
			readMue(m, "/Users/kokaly/Desktop/mue");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		m.print();
	}

}
