package mapping;

import java.util.LinkedList;

import mapping.data.Job;

/**
 * Every Job Class has its own queue in the LPAS_DG and Gcu mapping schemes.
 * Class 1 corresponds to queue 0, class 2 corresponds to queue 1 .... class N
 * corresponds to queue N-1. This class is an implementation of a Queue
 * containing the jobs of one class.
 * 
 * @author Majd Kokaly
 * 
 */
public class JobsQueue {

	/**
	 * A linked list was used to implement this queue
	 */
	private LinkedList<Job> jobs;

	public JobsQueue() {
		jobs = new LinkedList<Job>();
	}

	public Job peak() {
		if (jobs.size() == 0)
			return null;
		return jobs.get(0);
	}

	public Job enqueue(Job job) {

		jobs.add(job);
		return job;
	}

	public Job dequeue() {
		if (jobs.size() == 0)
			return null;
		return jobs.removeFirst();
	}

	public int size() {
		return jobs.size();
	}

	public void print() {
		for (int i = 0; i < jobs.size(); i++) {
			System.out.println(jobs.get(i).toString());
		}
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		for (int i = 0; i < jobs.size(); i++) {
			buf.append(jobs.get(i).toString() + "\n");
		}

		return buf.toString();
	}

}
