
package mapping;

import java.util.Enumeration;

import mapping.data.Job;
import mapping.data.JobClass;
import mapping.data.Server;

/**
 * @author Majd Kokaly
 * 
 */
public class MET_MS extends MappingScheme {

	private static final long serialVersionUID = -264736842517619907L;

	public MET_MS(Mapper mapper) {
		super(mapper);
		this.setDescription("MET");
	}


	public void startMappingScheme() {

	}

	public Server getMin( Job job) { // i is the
																// class of
																// tasks. MET
																// dependent

		JobClass jobClass = this.getMapper().getClassesTable().get(
				(int) this.getMapper().getJobsTable().getJobClassID(job.getIndex()));
		if (this.getMapper().getServersTable().isEmpty()) { // In case of empty list
			return null;
		}
		Enumeration<Server> records = this.getMapper().getServersTable().elements();
		Server temp = records.nextElement();
		Server minRecord = temp;
		double min = temp.getTimeToBeTaskFree() + temp.getProcessingRate(jobClass.getIndex()).getAssumedRate(); // TODO
																										// Be
																										// careful
																										// to
																										// check
																										// if
																										// out
																										// of
																										// bound
																										// INFINITY
																										// PROBLEM

		for (; records.hasMoreElements();) {
			temp = records.nextElement();
			if (min > (temp.getTimeToBeTaskFree() + temp.getProcessingRate(jobClass.getIndex()).getAssumedRate())) {
				minRecord = temp;
				min = minRecord.getTimeToBeTaskFree() + minRecord.getProcessingRate(jobClass.getIndex()).getAssumedRate();
			}
			temp = records.nextElement(); // TODO next???
		}
		return minRecord;
	}

	public void mapJob(Job job) {
		this.getMapper().sendJob(job.getIndex() , getMin(job).getIndex()  );
	}

	@Override
	public void stopMappingScheme() {
		// TODO Auto-generated method stub

	}

	public void handleJobTimeOut(long jobID) {
		
	}


	@Override
	public void serverIsDown(int serverID) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void serverIsUp(int serverID) {
		// TODO Auto-generated method stub
		
	}

}
