package mapping.data;

import java.io.Serializable;

/**
 * This class represents a job class.
 * 
 * @author Majd Kokaly
 * 
 */
public class JobClass implements Serializable {

	/**
	 * The serialVersionUID is used to universally identify this version of this
	 * class.
	 */
	private static final long serialVersionUID = -4658146363353970814L;

	/**
	 * Every job class has an arrival rate. Please refer to Section Workload
	 * model in the thesis document.
	 */
	private double arrivalRate;

	/**
	 * Every job class has an execution time. Please refer to Appendix C in the
	 * thesis document.
	 */
	private long executionTime = 100;

	/**
	 * This is the job class index or ID. This defines the row of this job class
	 * in the mue matrix. Please refer to Section Workload model in the thesis
	 * document.
	 */
	private int index;
	
	/**
	 * A constructor
	 * @param arrivalRate the arrival rate of this job class.
	 */
	public JobClass(double arrivalRate) {
		this.setArrivalRate(arrivalRate);
	}
	
	/**
	 * A constructor
	 * @param arrivalRate the arrival rate of this job class.
	 * @param executionTime the executionTime of this job class.
	 */
	public JobClass(double arrivalRate, long executionTime) {
		this.setArrivalRate(arrivalRate);
		this.setexecutionTime(executionTime);
	}

	public double getArrivalRate() {
		return arrivalRate;
	}

	public void setArrivalRate(double arrivalRate) {
		this.arrivalRate = arrivalRate;
	}

	public long getexecutionTime() {
		return executionTime;
	}

	public void setexecutionTime(long executionTime) {
		this.executionTime = executionTime;
	}

	public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public String toString() {
		return "Job Class (" + this.getIndex() + ") :" + " and Arrival Rate: " + this.getArrivalRate()
				+ " and executionTime: " + this.getexecutionTime();
	}

}
