
package mapping.data;

/**
 * This class represents a vector of two elements and is used to implement
 * the DeltaStar Matrix as a Sparse Matrix.
 * 
 * @author Majd Kokaly
 */
public class Tuple {
	/**
	 * This value determines what row.
	 */
	int row;
	
	/**
	 * This value determines what column
	 */
	int col;

	public Tuple(int i, int j) {
		this.setRow(i);
		this.setCol(j);
	}

	public int getRow() {
		return row;
	}

	public void setRow(int row) {
		this.row = row;
	}

	public int getCol() {
		return col;
	}

	public void setCol(int col) {
		this.col = col;
	}

	public String toString() {
		return "(" + this.getRow() + "," + this.getCol() + ")";
	}

	/**
	 * @see Object#equals(Object)
	 */
	public boolean equals(Object o) {
		if (this.getRow() == ((Tuple) (o)).getRow() && this.getCol() == ((Tuple) (o)).getCol())
			return true;
		else
			return false;
	}

	public int hashCode() {
		return this.getRow() + this.getCol();
	}

}
