package probability_distribution;

/**
 * This class implements the Uniform distribution.
 * 
 * @author Majd Kokaly
 * 
 */
public class UniformDist extends ProbabilityDist {

	/**
	 * is a number that expresses the smallest number this distribution can
	 * return
	 */
	double lowerLimit;

	/**
	 * is a number that expresses the largest number this distribution can
	 * return
	 */
	double upperLimit;

	/**
	 * A constructor that produce a UniformDist object that return number
	 * between a lowerLimit and a upperLimit of range. For example invoking
	 * UniformDist(1,9) will create an UniformDist object that produces number
	 * in the period [1,9)
	 * 
	 * @param lowerLimit
	 *            defines the beginning of the range.
	 * @param upperLimit
	 *            defines the end of the range.
	 */
	public UniformDist(double lowerLimit, double upperLimit) {
		this.setLowerLimit(lowerLimit);
		this.setUpperLimit(upperLimit);
	}

	/**
	 * A constructor that produce a UniformDist object that return number
	 * between a amount - (percentage*amount) and a amount +
	 * (percentage*amount). For example invoking UniformDist(10, 0.20, true) will
	 * create an UniformDist object that produces number in the period [9,11)
	 * 
	 * @param ammount
	 *            defines the mean of this distribution
	 * @param percentage
	 *            determine the length of the range. (amount * percentage *2) is
	 *            the length of the range.
	 * @param dummy
	 *            just a dummy value to distinguish this constructor from the
	 *            other ones
	 */
	public UniformDist(double ammount, double percentage, boolean dummy) {
		if (ammount * percentage > 0) {
			this.setLowerLimit((ammount * percentage) / 2 * -1);
			this.setUpperLimit((ammount * percentage) / 2 * 1);
		} else {
			this.setLowerLimit((ammount * percentage) / 2 * 1);
			this.setUpperLimit((ammount * percentage) / 2 * -1);
		}

	}

	/**
	 * Invoking this is equivalent to invoke UniformDist(1, percentage, true)
	 * @param percentage
	 *            determine the length of the range. (percentage * 2) is
	 *            the length of the range.
	 */
	public UniformDist(double percentage) {
		if (percentage > 0) {
			this.setLowerLimit(percentage / 2 * -1);
			this.setUpperLimit(percentage / 2 * 1);
		} else { // percentage <=
			this.setLowerLimit(percentage / 2 * 1);
			this.setUpperLimit(percentage / 2 * -1);
		}

	}

	private double getLowerLimit() {
		return lowerLimit;
	}

	private void setLowerLimit(double lowerLimit) {
		this.lowerLimit = lowerLimit;
	}

	private double getUpperLimit() {
		return upperLimit;
	}

	private void setUpperLimit(double upperLimit) {
		this.upperLimit = upperLimit;
	}
	
	/**
	 * @see ProbabilityDist#getNextValue()
	 */
	public double FInverse(double x) {
		return (x * (this.getUpperLimit() - this.getLowerLimit()) + this
				.getLowerLimit());
	}
	
	public double FInverse()
	{
		return (Math.random() * (this.getUpperLimit() - this.getLowerLimit()) + this.getLowerLimit());
	}
}
