package pulling.availability_imposer;

import java.io.Serializable;

/**
 * This class resembles the arches (edges)  between Node in the Availability Net
 * 
 * @author Majd Kokaly
 */
public class Arch implements Serializable {
	/**
	 * The serialVersionUID is used to universally identify this version of this class. 
	 */
	private static final long serialVersionUID = -7540459353072888329L;
	
	/**
	 * The probability of taking this arch from the source node
	 */
	private double probability;
	
	/**
	 * The node that this Arch leads to
	 */
	private Node destinationNode;
	
	/**
	 * A default constructor
	 * @param probability to set the probability field
	 * @param distinationNode to set the destinationNode
	 */
	public Arch(double probability, Node distinationNode) {
		this.setProbability(probability);
		this.setDestinationNode(distinationNode);
	}
	
	protected double getProbability() {
		return probability;
	}
	protected void setProbability(double probability) {
		this.probability = probability;
	}
	protected Node getDestinationNode() {
		return destinationNode;
	}
	protected void setDestinationNode(Node destinationNode) {
		this.destinationNode = destinationNode;
	}
	public String toString() {
		return "P = " + this.getProbability() + "-->" + this.getDestinationNode().getDescription(); 
	}
	
	
	
}
