package pulling.availability_imposer;


import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;



/**
 * This class is responsible for launching processes that eats the CPU time of current machine
 * @author Majd Kokaly
 *
 */
public class CPU_EatersLauncher  {
	
	/**
	 * The percentage of CPU time to be eaten from the processor
	 */
	private double percentage;
	
	/**
	 * The duration in minutes for the eating process
	 */
	private double forHowLong; // In minutes
	
	/**
	 * A list of OS processes active
	 */
	private ArrayList<Process> processes;
	
	/**
	 * Default constructor.
	 * @param percentage to set the percentage field 
	 * @param forHowLong to set the the forHowLong field
	 */
	public CPU_EatersLauncher(double percentage, double forHowLong) {
		this.setPercentage(percentage);
		this.setForHowLong(forHowLong);
		processes = new ArrayList<Process> (3);
	}
	
	public double getPercentage() {
		return percentage;
	}

	public synchronized void setPercentage(double percentage) {
		this.percentage = percentage;
	}

	public synchronized double getForHowLong() {
		return forHowLong;
	}

	public synchronized void setForHowLong(double forHowLong) {
		this.forHowLong = forHowLong;
	}
	
	/**
	 * This method starts the eater.
	 */
	public void startEaters() {
		this.launchEnoughCPU_EatersToEat(this.getPercentage(), this.getForHowLong());	
	}
	
	/**
	 * This method stops the eater.
	 */
	public void stopEaters() {
		for (int i = 0; i < processes.size(); i++)
			processes.get(i).destroy();
	}	
	
	
	/**
	 * This method checks the number of cores existing in the system and launch eaters accordingly.
	 * 
	 * @param percentage The percentage of CPU time to be eaten from the processor
	 * @param forHowLong The duration in minutes for the eating process
	 */
	public void launchEnoughCPU_EatersToEat(double percentage, double forHowLong) {
		int numberOfCores = Runtime.getRuntime().availableProcessors();
		
		for  (int i = 0; i < numberOfCores - 1; i++) {
			launchCPU_EaterProcess( 1 , forHowLong); // to make all cores but one busy.
		}
		
		launchCPU_EaterProcess(percentage, forHowLong);	
	}
	
	/**
	 * This method starts the OS processes that is responsible for eating the CPU.
	 * 
	 * @param percentage The percentage of CPU time to be eaten from the processor
	 * @param forHowLong The duration in minutes for the eating process
	 */
	private void launchCPU_EaterProcess(double percentage, double forHowLong) {
		
		
		String command = "java -jar " + "eater.jar " + percentage + " " + forHowLong;
		System.out.println("command: " + command);
		
		
		Runtime runtime = Runtime.getRuntime();
		Process process = null;
		try {
			process = runtime.exec(command);
			process.toString();
			
			processes.add(process);
			
			InputStream inputstream = process.getInputStream();
			InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
			BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
			bufferedreader.toString();
		
			
			InputStream errorstream = process.getErrorStream();
			InputStreamReader errorstreamreader = new InputStreamReader(errorstream);
			BufferedReader errorbufferedreader = new BufferedReader(errorstreamreader);
			errorbufferedreader.toString();			
		
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
	

}
